/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.metrics.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import de.fzi.maintainabilitymodel.metrics.*;
import de.fzi.maintainabilitymodel.metrics.ComplexityMeasure;
import de.fzi.maintainabilitymodel.metrics.CostMeasure;
import de.fzi.maintainabilitymodel.metrics.CostMetric;
import de.fzi.maintainabilitymodel.metrics.EffortMetric;
import de.fzi.maintainabilitymodel.metrics.Estimate;
import de.fzi.maintainabilitymodel.metrics.Metric;
import de.fzi.maintainabilitymodel.metrics.MetricsPackage;
import de.fzi.maintainabilitymodel.metrics.TimeMeasure;
import de.fzi.maintainabilitymodel.metrics.TimeMetric;
import de.fzi.maintainabilitymodel.metrics.WorkloadMetric;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.metrics.MetricsPackage
 * @generated
 */
public class MetricsSwitch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static MetricsPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MetricsSwitch() {
        if (modelPackage == null) {
            modelPackage = MetricsPackage.eINSTANCE;
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	public T doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List<EClass> eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch(eSuperTypes.get(0), theEObject);
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case MetricsPackage.EFFORT_METRIC: {
                EffortMetric effortMetric = (EffortMetric)theEObject;
                T result = caseEffortMetric(effortMetric);
                if (result == null) result = caseMetric(effortMetric);
                if (result == null) result = caseNamedEntity(effortMetric);
                if (result == null) result = caseEntity(effortMetric);
                if (result == null) result = caseIdentifier(effortMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.WORKLOAD_METRIC: {
                WorkloadMetric workloadMetric = (WorkloadMetric)theEObject;
                T result = caseWorkloadMetric(workloadMetric);
                if (result == null) result = caseMetric(workloadMetric);
                if (result == null) result = caseNamedEntity(workloadMetric);
                if (result == null) result = caseEntity(workloadMetric);
                if (result == null) result = caseIdentifier(workloadMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.TIME_METRIC: {
                TimeMetric timeMetric = (TimeMetric)theEObject;
                T result = caseTimeMetric(timeMetric);
                if (result == null) result = caseMetric(timeMetric);
                if (result == null) result = caseNamedEntity(timeMetric);
                if (result == null) result = caseEntity(timeMetric);
                if (result == null) result = caseIdentifier(timeMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.COST_METRIC: {
                CostMetric costMetric = (CostMetric)theEObject;
                T result = caseCostMetric(costMetric);
                if (result == null) result = caseMetric(costMetric);
                if (result == null) result = caseNamedEntity(costMetric);
                if (result == null) result = caseEntity(costMetric);
                if (result == null) result = caseIdentifier(costMetric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.ESTIMATE: {
                Estimate estimate = (Estimate)theEObject;
                T result = caseEstimate(estimate);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.TIME_MEASURE: {
                TimeMeasure timeMeasure = (TimeMeasure)theEObject;
                T result = caseTimeMeasure(timeMeasure);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.COST_MEASURE: {
                CostMeasure costMeasure = (CostMeasure)theEObject;
                T result = caseCostMeasure(costMeasure);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.COMPLEXITY_MEASURE: {
                ComplexityMeasure complexityMeasure = (ComplexityMeasure)theEObject;
                T result = caseComplexityMeasure(complexityMeasure);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MetricsPackage.METRIC: {
                Metric metric = (Metric)theEObject;
                T result = caseMetric(metric);
                if (result == null) result = caseNamedEntity(metric);
                if (result == null) result = caseEntity(metric);
                if (result == null) result = caseIdentifier(metric);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Effort Metric</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Effort Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEffortMetric(EffortMetric object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Metric</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseMetric(Metric object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Workload Metric</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Workload Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseWorkloadMetric(WorkloadMetric object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Cost Metric</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Cost Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseCostMetric(CostMetric object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Time Measure</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Time Measure</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseTimeMeasure(TimeMeasure object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Cost Measure</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Cost Measure</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseCostMeasure(CostMeasure object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Complexity Measure</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Complexity Measure</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseComplexityMeasure(ComplexityMeasure object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Estimate</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Estimate</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEstimate(Estimate object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Time Metric</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Time Metric</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseTimeMetric(TimeMetric object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseIdentifier(Identifier object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEntity(Entity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseNamedEntity(NamedEntity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	public T defaultCase(EObject object) {
        return null;
    }

} //MetricsSwitch
