/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.metrics.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import de.fzi.maintainabilitymodel.metrics.*;
import de.fzi.maintainabilitymodel.metrics.ComplexityMeasure;
import de.fzi.maintainabilitymodel.metrics.CostMeasure;
import de.fzi.maintainabilitymodel.metrics.CostMetric;
import de.fzi.maintainabilitymodel.metrics.EffortMetric;
import de.fzi.maintainabilitymodel.metrics.Estimate;
import de.fzi.maintainabilitymodel.metrics.Metric;
import de.fzi.maintainabilitymodel.metrics.MetricsPackage;
import de.fzi.maintainabilitymodel.metrics.TimeMeasure;
import de.fzi.maintainabilitymodel.metrics.TimeMetric;
import de.fzi.maintainabilitymodel.metrics.WorkloadMetric;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.metrics.MetricsPackage
 * @generated
 */
public class MetricsAdapterFactory extends AdapterFactoryImpl {
	/**
     * The cached model package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static MetricsPackage modelPackage;

	/**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MetricsAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = MetricsPackage.eINSTANCE;
        }
    }

	/**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

	/**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected MetricsSwitch<Adapter> modelSwitch =
		new MetricsSwitch<Adapter>() {
            @Override
            public Adapter caseEffortMetric(EffortMetric object) {
                return createEffortMetricAdapter();
            }
            @Override
            public Adapter caseWorkloadMetric(WorkloadMetric object) {
                return createWorkloadMetricAdapter();
            }
            @Override
            public Adapter caseTimeMetric(TimeMetric object) {
                return createTimeMetricAdapter();
            }
            @Override
            public Adapter caseCostMetric(CostMetric object) {
                return createCostMetricAdapter();
            }
            @Override
            public Adapter caseEstimate(Estimate object) {
                return createEstimateAdapter();
            }
            @Override
            public Adapter caseTimeMeasure(TimeMeasure object) {
                return createTimeMeasureAdapter();
            }
            @Override
            public Adapter caseCostMeasure(CostMeasure object) {
                return createCostMeasureAdapter();
            }
            @Override
            public Adapter caseComplexityMeasure(ComplexityMeasure object) {
                return createComplexityMeasureAdapter();
            }
            @Override
            public Adapter caseMetric(Metric object) {
                return createMetricAdapter();
            }
            @Override
            public Adapter caseIdentifier(Identifier object) {
                return createIdentifierAdapter();
            }
            @Override
            public Adapter caseEntity(Entity object) {
                return createEntityAdapter();
            }
            @Override
            public Adapter caseNamedEntity(NamedEntity object) {
                return createNamedEntityAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

	/**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
	@Override
	public Adapter createAdapter(Notifier target) {
        return modelSwitch.doSwitch((EObject)target);
    }


	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.EffortMetric <em>Effort Metric</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.EffortMetric
     * @generated
     */
	public Adapter createEffortMetricAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.Metric <em>Metric</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.Metric
     * @generated
     */
	public Adapter createMetricAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.WorkloadMetric <em>Workload Metric</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.WorkloadMetric
     * @generated
     */
	public Adapter createWorkloadMetricAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.CostMetric <em>Cost Metric</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.CostMetric
     * @generated
     */
	public Adapter createCostMetricAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.TimeMeasure <em>Time Measure</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.TimeMeasure
     * @generated
     */
	public Adapter createTimeMeasureAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.CostMeasure <em>Cost Measure</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.CostMeasure
     * @generated
     */
	public Adapter createCostMeasureAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.ComplexityMeasure <em>Complexity Measure</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.ComplexityMeasure
     * @generated
     */
	public Adapter createComplexityMeasureAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.Estimate <em>Estimate</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.Estimate
     * @generated
     */
	public Adapter createEstimateAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.metrics.TimeMetric <em>Time Metric</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.metrics.TimeMetric
     * @generated
     */
	public Adapter createTimeMetricAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link eu.qimpress.identifier.Identifier <em>Identifier</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see eu.qimpress.identifier.Identifier
     * @generated
     */
	public Adapter createIdentifierAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.main.Entity <em>Entity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.main.Entity
     * @generated
     */
	public Adapter createEntityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for an object of class '{@link de.fzi.maintainabilitymodel.main.NamedEntity <em>Named Entity</em>}'.
     * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @see de.fzi.maintainabilitymodel.main.NamedEntity
     * @generated
     */
	public Adapter createNamedEntityAdapter() {
        return null;
    }

	/**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
	public Adapter createEObjectAdapter() {
        return null;
    }

} //MetricsAdapterFactory
