/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.metrics.impl;

import de.fzi.maintainabilitymodel.metrics.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.fzi.maintainabilitymodel.metrics.ComplexityMeasure;
import de.fzi.maintainabilitymodel.metrics.CostMeasure;
import de.fzi.maintainabilitymodel.metrics.CostMetric;
import de.fzi.maintainabilitymodel.metrics.EffortMetric;
import de.fzi.maintainabilitymodel.metrics.Estimate;
import de.fzi.maintainabilitymodel.metrics.MetricsFactory;
import de.fzi.maintainabilitymodel.metrics.MetricsPackage;
import de.fzi.maintainabilitymodel.metrics.TimeMeasure;
import de.fzi.maintainabilitymodel.metrics.TimeMetric;
import de.fzi.maintainabilitymodel.metrics.WorkloadMetric;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MetricsFactoryImpl extends EFactoryImpl implements MetricsFactory {
	/**
     * Creates the default factory implementation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static MetricsFactory init() {
        try {
            MetricsFactory theMetricsFactory = (MetricsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.fzi.de/maintainabilitymodel/metrics"); 
            if (theMetricsFactory != null) {
                return theMetricsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new MetricsFactoryImpl();
    }

	/**
     * Creates an instance of the factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MetricsFactoryImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case MetricsPackage.EFFORT_METRIC: return createEffortMetric();
            case MetricsPackage.WORKLOAD_METRIC: return createWorkloadMetric();
            case MetricsPackage.TIME_METRIC: return createTimeMetric();
            case MetricsPackage.COST_METRIC: return createCostMetric();
            case MetricsPackage.ESTIMATE: return createEstimate();
            case MetricsPackage.TIME_MEASURE: return createTimeMeasure();
            case MetricsPackage.COST_MEASURE: return createCostMeasure();
            case MetricsPackage.COMPLEXITY_MEASURE: return createComplexityMeasure();
            default:
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EffortMetric createEffortMetric() {
        EffortMetricImpl effortMetric = new EffortMetricImpl();
        return effortMetric;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkloadMetric createWorkloadMetric() {
        WorkloadMetricImpl workloadMetric = new WorkloadMetricImpl();
        return workloadMetric;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CostMetric createCostMetric() {
        CostMetricImpl costMetric = new CostMetricImpl();
        return costMetric;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TimeMeasure createTimeMeasure() {
        TimeMeasureImpl timeMeasure = new TimeMeasureImpl();
        return timeMeasure;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CostMeasure createCostMeasure() {
        CostMeasureImpl costMeasure = new CostMeasureImpl();
        return costMeasure;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComplexityMeasure createComplexityMeasure() {
        ComplexityMeasureImpl complexityMeasure = new ComplexityMeasureImpl();
        return complexityMeasure;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Estimate createEstimate() {
        EstimateImpl estimate = new EstimateImpl();
        return estimate;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TimeMetric createTimeMetric() {
        TimeMetricImpl timeMetric = new TimeMetricImpl();
        return timeMetric;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MetricsPackage getMetricsPackage() {
        return (MetricsPackage)getEPackage();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @deprecated
     * @generated
     */
	@Deprecated
	public static MetricsPackage getPackage() {
        return MetricsPackage.eINSTANCE;
    }

} //MetricsFactoryImpl
