/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.metrics;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.maintainabilitymodel.main.MainPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.metrics.MetricsFactory
 * @model kind="package"
 * @generated
 */
public interface MetricsPackage extends EPackage {
	/**
     * The package name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNAME = "metrics";

	/**
     * The package namespace URI.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_URI = "http://www.fzi.de/maintainabilitymodel/metrics";

	/**
     * The package namespace name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_PREFIX = "metrics";

	/**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	MetricsPackage eINSTANCE = de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl.init();

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.MetricImpl <em>Metric</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getMetric()
     * @generated
     */
	int METRIC = 8;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int METRIC__ID = MainPackage.NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int METRIC__NAME = MainPackage.NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Unit</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int METRIC__UNIT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The number of structural features of the '<em>Metric</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int METRIC_FEATURE_COUNT = MainPackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.EffortMetricImpl <em>Effort Metric</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.EffortMetricImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getEffortMetric()
     * @generated
     */
	int EFFORT_METRIC = 0;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_METRIC__ID = METRIC__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_METRIC__NAME = METRIC__NAME;

	/**
     * The feature id for the '<em><b>Unit</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_METRIC__UNIT = METRIC__UNIT;

	/**
     * The number of structural features of the '<em>Effort Metric</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_METRIC_FEATURE_COUNT = METRIC_FEATURE_COUNT + 0;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.WorkloadMetricImpl <em>Workload Metric</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.WorkloadMetricImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getWorkloadMetric()
     * @generated
     */
	int WORKLOAD_METRIC = 1;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKLOAD_METRIC__ID = METRIC__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKLOAD_METRIC__NAME = METRIC__NAME;

	/**
     * The feature id for the '<em><b>Unit</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKLOAD_METRIC__UNIT = METRIC__UNIT;

	/**
     * The number of structural features of the '<em>Workload Metric</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int WORKLOAD_METRIC_FEATURE_COUNT = METRIC_FEATURE_COUNT + 0;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.CostMetricImpl <em>Cost Metric</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.CostMetricImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getCostMetric()
     * @generated
     */
	int COST_METRIC = 3;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.EstimateImpl <em>Estimate</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.EstimateImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getEstimate()
     * @generated
     */
	int ESTIMATE = 4;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.TimeMetricImpl <em>Time Metric</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.TimeMetricImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getTimeMetric()
     * @generated
     */
	int TIME_METRIC = 2;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TIME_METRIC__ID = METRIC__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TIME_METRIC__NAME = METRIC__NAME;

	/**
     * The feature id for the '<em><b>Unit</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TIME_METRIC__UNIT = METRIC__UNIT;

	/**
     * The number of structural features of the '<em>Time Metric</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TIME_METRIC_FEATURE_COUNT = METRIC_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COST_METRIC__ID = METRIC__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COST_METRIC__NAME = METRIC__NAME;

	/**
     * The feature id for the '<em><b>Unit</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COST_METRIC__UNIT = METRIC__UNIT;

	/**
     * The number of structural features of the '<em>Cost Metric</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COST_METRIC_FEATURE_COUNT = METRIC_FEATURE_COUNT + 0;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.TimeMeasureImpl <em>Time Measure</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.TimeMeasureImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getTimeMeasure()
     * @generated
     */
	int TIME_MEASURE = 5;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.CostMeasureImpl <em>Cost Measure</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.CostMeasureImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getCostMeasure()
     * @generated
     */
	int COST_MEASURE = 6;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.metrics.impl.ComplexityMeasureImpl <em>Complexity Measure</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.metrics.impl.ComplexityMeasureImpl
     * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getComplexityMeasure()
     * @generated
     */
	int COMPLEXITY_MEASURE = 7;

	/**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ESTIMATE__VALUE = 0;

	/**
     * The feature id for the '<em><b>Metric</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ESTIMATE__METRIC = 1;

	/**
     * The number of structural features of the '<em>Estimate</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ESTIMATE_FEATURE_COUNT = 2;

	/**
     * The number of structural features of the '<em>Time Measure</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TIME_MEASURE_FEATURE_COUNT = 0;

	/**
     * The number of structural features of the '<em>Cost Measure</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COST_MEASURE_FEATURE_COUNT = 0;

	/**
     * The number of structural features of the '<em>Complexity Measure</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int COMPLEXITY_MEASURE_FEATURE_COUNT = 0;


	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.EffortMetric <em>Effort Metric</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Effort Metric</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.EffortMetric
     * @generated
     */
	EClass getEffortMetric();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.Metric <em>Metric</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Metric</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.Metric
     * @generated
     */
	EClass getMetric();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.metrics.Metric#getUnit <em>Unit</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Unit</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.Metric#getUnit()
     * @see #getMetric()
     * @generated
     */
	EAttribute getMetric_Unit();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.WorkloadMetric <em>Workload Metric</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Workload Metric</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.WorkloadMetric
     * @generated
     */
	EClass getWorkloadMetric();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.CostMetric <em>Cost Metric</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Cost Metric</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.CostMetric
     * @generated
     */
	EClass getCostMetric();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.TimeMeasure <em>Time Measure</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Time Measure</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.TimeMeasure
     * @generated
     */
	EClass getTimeMeasure();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.CostMeasure <em>Cost Measure</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Cost Measure</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.CostMeasure
     * @generated
     */
	EClass getCostMeasure();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.ComplexityMeasure <em>Complexity Measure</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Complexity Measure</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.ComplexityMeasure
     * @generated
     */
	EClass getComplexityMeasure();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.Estimate <em>Estimate</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Estimate</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.Estimate
     * @generated
     */
	EClass getEstimate();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.metrics.Estimate#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.Estimate#getValue()
     * @see #getEstimate()
     * @generated
     */
	EAttribute getEstimate_Value();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.metrics.Estimate#getMetric <em>Metric</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Metric</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.Estimate#getMetric()
     * @see #getEstimate()
     * @generated
     */
	EReference getEstimate_Metric();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.metrics.TimeMetric <em>Time Metric</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Time Metric</em>'.
     * @see de.fzi.maintainabilitymodel.metrics.TimeMetric
     * @generated
     */
	EClass getTimeMetric();

	/**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
	MetricsFactory getMetricsFactory();

	/**
     * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
     * @generated
     */
	interface Literals {
		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.EffortMetricImpl <em>Effort Metric</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.EffortMetricImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getEffortMetric()
         * @generated
         */
		EClass EFFORT_METRIC = eINSTANCE.getEffortMetric();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.MetricImpl <em>Metric</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getMetric()
         * @generated
         */
		EClass METRIC = eINSTANCE.getMetric();

		/**
         * The meta object literal for the '<em><b>Unit</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute METRIC__UNIT = eINSTANCE.getMetric_Unit();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.WorkloadMetricImpl <em>Workload Metric</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.WorkloadMetricImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getWorkloadMetric()
         * @generated
         */
		EClass WORKLOAD_METRIC = eINSTANCE.getWorkloadMetric();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.CostMetricImpl <em>Cost Metric</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.CostMetricImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getCostMetric()
         * @generated
         */
		EClass COST_METRIC = eINSTANCE.getCostMetric();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.TimeMeasureImpl <em>Time Measure</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.TimeMeasureImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getTimeMeasure()
         * @generated
         */
		EClass TIME_MEASURE = eINSTANCE.getTimeMeasure();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.CostMeasureImpl <em>Cost Measure</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.CostMeasureImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getCostMeasure()
         * @generated
         */
		EClass COST_MEASURE = eINSTANCE.getCostMeasure();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.ComplexityMeasureImpl <em>Complexity Measure</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.ComplexityMeasureImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getComplexityMeasure()
         * @generated
         */
		EClass COMPLEXITY_MEASURE = eINSTANCE.getComplexityMeasure();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.EstimateImpl <em>Estimate</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.EstimateImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getEstimate()
         * @generated
         */
		EClass ESTIMATE = eINSTANCE.getEstimate();

		/**
         * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute ESTIMATE__VALUE = eINSTANCE.getEstimate_Value();

		/**
         * The meta object literal for the '<em><b>Metric</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference ESTIMATE__METRIC = eINSTANCE.getEstimate_Metric();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.metrics.impl.TimeMetricImpl <em>Time Metric</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.metrics.impl.TimeMetricImpl
         * @see de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl#getTimeMetric()
         * @generated
         */
		EClass TIME_METRIC = eINSTANCE.getTimeMetric();

	}

} //MetricsPackage
