/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.main.util;

import de.fzi.maintainabilitymodel.main.*;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.main.MainPackage
 * @generated
 */
public class MainSwitch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static MainPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MainSwitch() {
        if (modelPackage == null) {
            modelPackage = MainPackage.eINSTANCE;
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	public T doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List<EClass> eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch(eSuperTypes.get(0), theEObject);
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL: {
                MaintainabilityAnalysisModel maintainabilityAnalysisModel = (MaintainabilityAnalysisModel)theEObject;
                T result = caseMaintainabilityAnalysisModel(maintainabilityAnalysisModel);
                if (result == null) result = caseNamedEntity(maintainabilityAnalysisModel);
                if (result == null) result = caseEntity(maintainabilityAnalysisModel);
                if (result == null) result = caseIdentifier(maintainabilityAnalysisModel);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MainPackage.EFFORT_ANALYSIS_INSTANCE: {
                EffortAnalysisInstance effortAnalysisInstance = (EffortAnalysisInstance)theEObject;
                T result = caseEffortAnalysisInstance(effortAnalysisInstance);
                if (result == null) result = caseNamedEntity(effortAnalysisInstance);
                if (result == null) result = caseEntity(effortAnalysisInstance);
                if (result == null) result = caseIdentifier(effortAnalysisInstance);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MainPackage.ENTITY: {
                Entity entity = (Entity)theEObject;
                T result = caseEntity(entity);
                if (result == null) result = caseIdentifier(entity);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MainPackage.NAMED_ENTITY: {
                NamedEntity namedEntity = (NamedEntity)theEObject;
                T result = caseNamedEntity(namedEntity);
                if (result == null) result = caseEntity(namedEntity);
                if (result == null) result = caseIdentifier(namedEntity);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Maintainability Analysis Model</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Maintainability Analysis Model</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseMaintainabilityAnalysisModel(MaintainabilityAnalysisModel object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Effort Analysis Instance</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Effort Analysis Instance</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEffortAnalysisInstance(EffortAnalysisInstance object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEntity(Entity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseNamedEntity(NamedEntity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseIdentifier(Identifier object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	public T defaultCase(EObject object) {
        return null;
    }

} //MainSwitch
