/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.main.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.metrics.Metric;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Maintainability Analysis Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl#getWorkorganisation <em>Workorganisation</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl#getArchitecturealternatives <em>Architecturealternatives</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl#getChangerequests <em>Changerequests</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl#getAnalysisinstances <em>Analysisinstances</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl#getMetrics <em>Metrics</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl#getArchitecturemodels <em>Architecturemodels</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MaintainabilityAnalysisModelImpl extends NamedEntityImpl implements MaintainabilityAnalysisModel {
	/**
     * The cached value of the '{@link #getWorkorganisation() <em>Workorganisation</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getWorkorganisation()
     * @generated
     * @ordered
     */
	protected EList<WorkOrganisationModel> workorganisation;

	/**
     * The cached value of the '{@link #getArchitecturealternatives() <em>Architecturealternatives</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getArchitecturealternatives()
     * @generated
     * @ordered
     */
	protected EList<ArchitecturalAlternative> architecturealternatives;

	/**
     * The cached value of the '{@link #getChangerequests() <em>Changerequests</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getChangerequests()
     * @generated
     * @ordered
     */
	protected EList<ChangeRequest> changerequests;

	/**
     * The cached value of the '{@link #getAnalysisinstances() <em>Analysisinstances</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAnalysisinstances()
     * @generated
     * @ordered
     */
	protected EList<EffortAnalysisInstance> analysisinstances;

	/**
     * The cached value of the '{@link #getMetrics() <em>Metrics</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMetrics()
     * @generated
     * @ordered
     */
	protected EList<Metric> metrics;

	/**
     * The cached value of the '{@link #getArchitecturemodels() <em>Architecturemodels</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getArchitecturemodels()
     * @generated
     * @ordered
     */
	protected EList<AbstractArchitectureModel> architecturemodels;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected MaintainabilityAnalysisModelImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<WorkOrganisationModel> getWorkorganisation() {
        if (workorganisation == null) {
            workorganisation = new EObjectContainmentEList<WorkOrganisationModel>(WorkOrganisationModel.class, this, MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION);
        }
        return workorganisation;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<ArchitecturalAlternative> getArchitecturealternatives() {
        if (architecturealternatives == null) {
            architecturealternatives = new EObjectContainmentWithInverseEList<ArchitecturalAlternative>(ArchitecturalAlternative.class, this, MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES, WorkplanPackage.ARCHITECTURAL_ALTERNATIVE__MAINTAINABILITYANALYSISMODEL);
        }
        return architecturealternatives;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<ChangeRequest> getChangerequests() {
        if (changerequests == null) {
            changerequests = new EObjectContainmentWithInverseEList<ChangeRequest>(ChangeRequest.class, this, MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS, WorkplanPackage.CHANGE_REQUEST__MAINTAINABILITYANALYSISMODEL);
        }
        return changerequests;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<EffortAnalysisInstance> getAnalysisinstances() {
        if (analysisinstances == null) {
            analysisinstances = new EObjectContainmentWithInverseEList<EffortAnalysisInstance>(EffortAnalysisInstance.class, this, MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES, MainPackage.EFFORT_ANALYSIS_INSTANCE__MAINTAINABILITY_ANALYSIS_MODEL);
        }
        return analysisinstances;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<Metric> getMetrics() {
        if (metrics == null) {
            metrics = new EObjectContainmentEList<Metric>(Metric.class, this, MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS);
        }
        return metrics;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList<AbstractArchitectureModel> getArchitecturemodels() {
        if (architecturemodels == null) {
            architecturemodels = new EObjectContainmentEList<AbstractArchitectureModel>(AbstractArchitectureModel.class, this, MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS);
        }
        return architecturemodels;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getArchitecturealternatives()).basicAdd(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getChangerequests()).basicAdd(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getAnalysisinstances()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION:
                return ((InternalEList<?>)getWorkorganisation()).basicRemove(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
                return ((InternalEList<?>)getArchitecturealternatives()).basicRemove(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
                return ((InternalEList<?>)getChangerequests()).basicRemove(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
                return ((InternalEList<?>)getAnalysisinstances()).basicRemove(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS:
                return ((InternalEList<?>)getMetrics()).basicRemove(otherEnd, msgs);
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS:
                return ((InternalEList<?>)getArchitecturemodels()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION:
                return getWorkorganisation();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
                return getArchitecturealternatives();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
                return getChangerequests();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
                return getAnalysisinstances();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS:
                return getMetrics();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS:
                return getArchitecturemodels();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION:
                getWorkorganisation().clear();
                getWorkorganisation().addAll((Collection<? extends WorkOrganisationModel>)newValue);
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
                getArchitecturealternatives().clear();
                getArchitecturealternatives().addAll((Collection<? extends ArchitecturalAlternative>)newValue);
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
                getChangerequests().clear();
                getChangerequests().addAll((Collection<? extends ChangeRequest>)newValue);
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
                getAnalysisinstances().clear();
                getAnalysisinstances().addAll((Collection<? extends EffortAnalysisInstance>)newValue);
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS:
                getMetrics().clear();
                getMetrics().addAll((Collection<? extends Metric>)newValue);
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS:
                getArchitecturemodels().clear();
                getArchitecturemodels().addAll((Collection<? extends AbstractArchitectureModel>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION:
                getWorkorganisation().clear();
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
                getArchitecturealternatives().clear();
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
                getChangerequests().clear();
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
                getAnalysisinstances().clear();
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS:
                getMetrics().clear();
                return;
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS:
                getArchitecturemodels().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION:
                return workorganisation != null && !workorganisation.isEmpty();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
                return architecturealternatives != null && !architecturealternatives.isEmpty();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
                return changerequests != null && !changerequests.isEmpty();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
                return analysisinstances != null && !analysisinstances.isEmpty();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS:
                return metrics != null && !metrics.isEmpty();
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS:
                return architecturemodels != null && !architecturemodels.isEmpty();
        }
        return super.eIsSet(featureID);
    }

} //MaintainabilityAnalysisModelImpl
