/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.main;

import org.eclipse.emf.common.util.EList;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.metrics.Metric;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Maintainability Analysis Model</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents the root of the maintainability analysis model.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getWorkorganisation <em>Workorganisation</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getArchitecturealternatives <em>Architecturealternatives</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getChangerequests <em>Changerequests</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getAnalysisinstances <em>Analysisinstances</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getMetrics <em>Metrics</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getArchitecturemodels <em>Architecturemodels</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel()
 * @model
 * @generated
 */
public interface MaintainabilityAnalysisModel extends NamedEntity {
	/**
     * Returns the value of the '<em><b>Workorganisation</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel}.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Workorganisation</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Workorganisation</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel_Workorganisation()
     * @model containment="true" ordered="false"
     * @generated
     */
	EList<WorkOrganisationModel> getWorkorganisation();

	/**
     * Returns the value of the '<em><b>Architecturealternatives</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative}.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getMaintainabilityanalysismodel <em>Maintainabilityanalysismodel</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Architecturealternatives</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Architecturealternatives</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel_Architecturealternatives()
     * @see de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative#getMaintainabilityanalysismodel
     * @model opposite="maintainabilityanalysismodel" containment="true" ordered="false"
     * @generated
     */
	EList<ArchitecturalAlternative> getArchitecturealternatives();

	/**
     * Returns the value of the '<em><b>Changerequests</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.workplan.ChangeRequest}.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workplan.ChangeRequest#getMaintainabilityanalysismodel <em>Maintainabilityanalysismodel</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Changerequests</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Changerequests</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel_Changerequests()
     * @see de.fzi.maintainabilitymodel.workplan.ChangeRequest#getMaintainabilityanalysismodel
     * @model opposite="maintainabilityanalysismodel" containment="true" ordered="false"
     * @generated
     */
	EList<ChangeRequest> getChangerequests();

	/**
     * Returns the value of the '<em><b>Analysisinstances</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance}.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getMaintainabilityAnalysisModel <em>Maintainability Analysis Model</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Analysisinstances</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Analysisinstances</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel_Analysisinstances()
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getMaintainabilityAnalysisModel
     * @model opposite="maintainabilityAnalysisModel" containment="true" ordered="false"
     * @generated
     */
	EList<EffortAnalysisInstance> getAnalysisinstances();

	/**
     * Returns the value of the '<em><b>Metrics</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.metrics.Metric}.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Metrics</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Metrics</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel_Metrics()
     * @model containment="true" ordered="false"
     * @generated
     */
	EList<Metric> getMetrics();

	/**
     * Returns the value of the '<em><b>Architecturemodels</b></em>' containment reference list.
     * The list contents are of type {@link de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel}.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Architecturemodels</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Architecturemodels</em>' containment reference list.
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getMaintainabilityAnalysisModel_Architecturemodels()
     * @model containment="true" ordered="false"
     * @generated
     */
	EList<AbstractArchitectureModel> getArchitecturemodels();

} // MaintainabilityAnalysisModel
