/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.main;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import eu.qimpress.identifier.IdentifierPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.main.MainFactory
 * @model kind="package"
 * @generated
 */
public interface MainPackage extends EPackage {
	/**
     * The package name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNAME = "main";

	/**
     * The package namespace URI.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_URI = "http://www.fzi.de/maintainabilitymodel/main";

	/**
     * The package namespace name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_PREFIX = "main";

	/**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	MainPackage eINSTANCE = de.fzi.maintainabilitymodel.main.impl.MainPackageImpl.init();

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.main.impl.EntityImpl <em>Entity</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.main.impl.EntityImpl
     * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getEntity()
     * @generated
     */
	int ENTITY = 2;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ENTITY__ID = IdentifierPackage.IDENTIFIER__ID;

	/**
     * The number of structural features of the '<em>Entity</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int ENTITY_FEATURE_COUNT = IdentifierPackage.IDENTIFIER_FEATURE_COUNT + 0;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.main.impl.NamedEntityImpl <em>Named Entity</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.main.impl.NamedEntityImpl
     * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getNamedEntity()
     * @generated
     */
	int NAMED_ENTITY = 3;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int NAMED_ENTITY__ID = ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int NAMED_ENTITY__NAME = ENTITY_FEATURE_COUNT + 0;

	/**
     * The number of structural features of the '<em>Named Entity</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int NAMED_ENTITY_FEATURE_COUNT = ENTITY_FEATURE_COUNT + 1;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl <em>Maintainability Analysis Model</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl
     * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getMaintainabilityAnalysisModel()
     * @generated
     */
	int MAINTAINABILITY_ANALYSIS_MODEL = 0;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__ID = NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__NAME = NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Workorganisation</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION = NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Architecturealternatives</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES = NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
     * The feature id for the '<em><b>Changerequests</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS = NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
     * The feature id for the '<em><b>Analysisinstances</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES = NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
     * The feature id for the '<em><b>Metrics</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__METRICS = NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
     * The feature id for the '<em><b>Architecturemodels</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS = NAMED_ENTITY_FEATURE_COUNT + 5;

	/**
     * The number of structural features of the '<em>Maintainability Analysis Model</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int MAINTAINABILITY_ANALYSIS_MODEL_FEATURE_COUNT = NAMED_ENTITY_FEATURE_COUNT + 6;

	/**
     * The meta object id for the '{@link de.fzi.maintainabilitymodel.main.impl.EffortAnalysisInstanceImpl <em>Effort Analysis Instance</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see de.fzi.maintainabilitymodel.main.impl.EffortAnalysisInstanceImpl
     * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getEffortAnalysisInstance()
     * @generated
     */
	int EFFORT_ANALYSIS_INSTANCE = 1;

	/**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE__ID = NAMED_ENTITY__ID;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE__NAME = NAMED_ENTITY__NAME;

	/**
     * The feature id for the '<em><b>Workplan</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE__WORKPLAN = NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Source Architectural Alternative</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EFFORT_ANALYSIS_INSTANCE__SOURCE_ARCHITECTURAL_ALTERNATIVE = NAMED_ENTITY_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Changerequest</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE__CHANGEREQUEST = NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
     * The feature id for the '<em><b>Target Architectural Alternative</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE__TARGET_ARCHITECTURAL_ALTERNATIVE = NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
     * The feature id for the '<em><b>Maintainability Analysis Model</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE__MAINTAINABILITY_ANALYSIS_MODEL = NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
     * The number of structural features of the '<em>Effort Analysis Instance</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int EFFORT_ANALYSIS_INSTANCE_FEATURE_COUNT = NAMED_ENTITY_FEATURE_COUNT + 5;


	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel <em>Maintainability Analysis Model</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Maintainability Analysis Model</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel
     * @generated
     */
	EClass getMaintainabilityAnalysisModel();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getWorkorganisation <em>Workorganisation</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Workorganisation</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getWorkorganisation()
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	EReference getMaintainabilityAnalysisModel_Workorganisation();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getArchitecturealternatives <em>Architecturealternatives</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Architecturealternatives</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getArchitecturealternatives()
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	EReference getMaintainabilityAnalysisModel_Architecturealternatives();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getChangerequests <em>Changerequests</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Changerequests</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getChangerequests()
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	EReference getMaintainabilityAnalysisModel_Changerequests();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getAnalysisinstances <em>Analysisinstances</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Analysisinstances</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getAnalysisinstances()
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	EReference getMaintainabilityAnalysisModel_Analysisinstances();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getMetrics <em>Metrics</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Metrics</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getMetrics()
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	EReference getMaintainabilityAnalysisModel_Metrics();

	/**
     * Returns the meta object for the containment reference list '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getArchitecturemodels <em>Architecturemodels</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Architecturemodels</em>'.
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getArchitecturemodels()
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	EReference getMaintainabilityAnalysisModel_Architecturemodels();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance <em>Effort Analysis Instance</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Effort Analysis Instance</em>'.
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance
     * @generated
     */
	EClass getEffortAnalysisInstance();

	/**
     * Returns the meta object for the containment reference '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getWorkplan <em>Workplan</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Workplan</em>'.
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getWorkplan()
     * @see #getEffortAnalysisInstance()
     * @generated
     */
	EReference getEffortAnalysisInstance_Workplan();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getSourceArchitecturalAlternative <em>Source Architectural Alternative</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Source Architectural Alternative</em>'.
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getSourceArchitecturalAlternative()
     * @see #getEffortAnalysisInstance()
     * @generated
     */
    EReference getEffortAnalysisInstance_SourceArchitecturalAlternative();

    /**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getChangerequest <em>Changerequest</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Changerequest</em>'.
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getChangerequest()
     * @see #getEffortAnalysisInstance()
     * @generated
     */
	EReference getEffortAnalysisInstance_Changerequest();

	/**
     * Returns the meta object for the reference '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getTargetArchitecturalAlternative <em>Target Architectural Alternative</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Target Architectural Alternative</em>'.
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getTargetArchitecturalAlternative()
     * @see #getEffortAnalysisInstance()
     * @generated
     */
	EReference getEffortAnalysisInstance_TargetArchitecturalAlternative();

	/**
     * Returns the meta object for the container reference '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getMaintainabilityAnalysisModel <em>Maintainability Analysis Model</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Maintainability Analysis Model</em>'.
     * @see de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getMaintainabilityAnalysisModel()
     * @see #getEffortAnalysisInstance()
     * @generated
     */
	EReference getEffortAnalysisInstance_MaintainabilityAnalysisModel();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.main.Entity <em>Entity</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Entity</em>'.
     * @see de.fzi.maintainabilitymodel.main.Entity
     * @generated
     */
	EClass getEntity();

	/**
     * Returns the meta object for class '{@link de.fzi.maintainabilitymodel.main.NamedEntity <em>Named Entity</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Named Entity</em>'.
     * @see de.fzi.maintainabilitymodel.main.NamedEntity
     * @generated
     */
	EClass getNamedEntity();

	/**
     * Returns the meta object for the attribute '{@link de.fzi.maintainabilitymodel.main.NamedEntity#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see de.fzi.maintainabilitymodel.main.NamedEntity#getName()
     * @see #getNamedEntity()
     * @generated
     */
	EAttribute getNamedEntity_Name();

	/**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
	MainFactory getMainFactory();

	/**
     * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
     * @generated
     */
	interface Literals {
		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl <em>Maintainability Analysis Model</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.main.impl.MaintainabilityAnalysisModelImpl
         * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getMaintainabilityAnalysisModel()
         * @generated
         */
		EClass MAINTAINABILITY_ANALYSIS_MODEL = eINSTANCE.getMaintainabilityAnalysisModel();

		/**
         * The meta object literal for the '<em><b>Workorganisation</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION = eINSTANCE.getMaintainabilityAnalysisModel_Workorganisation();

		/**
         * The meta object literal for the '<em><b>Architecturealternatives</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES = eINSTANCE.getMaintainabilityAnalysisModel_Architecturealternatives();

		/**
         * The meta object literal for the '<em><b>Changerequests</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS = eINSTANCE.getMaintainabilityAnalysisModel_Changerequests();

		/**
         * The meta object literal for the '<em><b>Analysisinstances</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES = eINSTANCE.getMaintainabilityAnalysisModel_Analysisinstances();

		/**
         * The meta object literal for the '<em><b>Metrics</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference MAINTAINABILITY_ANALYSIS_MODEL__METRICS = eINSTANCE.getMaintainabilityAnalysisModel_Metrics();

		/**
         * The meta object literal for the '<em><b>Architecturemodels</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS = eINSTANCE.getMaintainabilityAnalysisModel_Architecturemodels();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.main.impl.EffortAnalysisInstanceImpl <em>Effort Analysis Instance</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.main.impl.EffortAnalysisInstanceImpl
         * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getEffortAnalysisInstance()
         * @generated
         */
		EClass EFFORT_ANALYSIS_INSTANCE = eINSTANCE.getEffortAnalysisInstance();

		/**
         * The meta object literal for the '<em><b>Workplan</b></em>' containment reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference EFFORT_ANALYSIS_INSTANCE__WORKPLAN = eINSTANCE.getEffortAnalysisInstance_Workplan();

		/**
         * The meta object literal for the '<em><b>Source Architectural Alternative</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference EFFORT_ANALYSIS_INSTANCE__SOURCE_ARCHITECTURAL_ALTERNATIVE = eINSTANCE.getEffortAnalysisInstance_SourceArchitecturalAlternative();

        /**
         * The meta object literal for the '<em><b>Changerequest</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference EFFORT_ANALYSIS_INSTANCE__CHANGEREQUEST = eINSTANCE.getEffortAnalysisInstance_Changerequest();

		/**
         * The meta object literal for the '<em><b>Target Architectural Alternative</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference EFFORT_ANALYSIS_INSTANCE__TARGET_ARCHITECTURAL_ALTERNATIVE = eINSTANCE.getEffortAnalysisInstance_TargetArchitecturalAlternative();

		/**
         * The meta object literal for the '<em><b>Maintainability Analysis Model</b></em>' container reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference EFFORT_ANALYSIS_INSTANCE__MAINTAINABILITY_ANALYSIS_MODEL = eINSTANCE.getEffortAnalysisInstance_MaintainabilityAnalysisModel();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.main.impl.EntityImpl <em>Entity</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.main.impl.EntityImpl
         * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getEntity()
         * @generated
         */
		EClass ENTITY = eINSTANCE.getEntity();

		/**
         * The meta object literal for the '{@link de.fzi.maintainabilitymodel.main.impl.NamedEntityImpl <em>Named Entity</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see de.fzi.maintainabilitymodel.main.impl.NamedEntityImpl
         * @see de.fzi.maintainabilitymodel.main.impl.MainPackageImpl#getNamedEntity()
         * @generated
         */
		EClass NAMED_ENTITY = eINSTANCE.getNamedEntity();

		/**
         * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute NAMED_ENTITY__NAME = eINSTANCE.getNamedEntity_Name();

	}

} //MainPackage
