/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.main;

import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import de.fzi.maintainabilitymodel.workplan.Workplan;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Effort Analysis Instance</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an instance of an effort analysis. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getWorkplan <em>Workplan</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getSourceArchitecturalAlternative <em>Source Architectural Alternative</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getChangerequest <em>Changerequest</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getTargetArchitecturalAlternative <em>Target Architectural Alternative</em>}</li>
 *   <li>{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getMaintainabilityAnalysisModel <em>Maintainability Analysis Model</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.maintainabilitymodel.main.MainPackage#getEffortAnalysisInstance()
 * @model
 * @generated
 */
public interface EffortAnalysisInstance extends NamedEntity {
	/**
     * Returns the value of the '<em><b>Workplan</b></em>' containment reference.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.workplan.Workplan#getEffortanalaysisinstance <em>Effortanalaysisinstance</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Workplan</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Workplan</em>' containment reference.
     * @see #setWorkplan(Workplan)
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getEffortAnalysisInstance_Workplan()
     * @see de.fzi.maintainabilitymodel.workplan.Workplan#getEffortanalaysisinstance
     * @model opposite="effortanalaysisinstance" containment="true" required="true" ordered="false"
     * @generated
     */
	Workplan getWorkplan();

	/**
     * Sets the value of the '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getWorkplan <em>Workplan</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Workplan</em>' containment reference.
     * @see #getWorkplan()
     * @generated
     */
	void setWorkplan(Workplan value);

	/**
     * Returns the value of the '<em><b>Source Architectural Alternative</b></em>' reference.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Source Architectural Alternative</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Source Architectural Alternative</em>' reference.
     * @see #setSourceArchitecturalAlternative(ArchitecturalAlternative)
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getEffortAnalysisInstance_SourceArchitecturalAlternative()
     * @model ordered="false"
     * @generated
     */
    ArchitecturalAlternative getSourceArchitecturalAlternative();

    /**
     * Sets the value of the '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getSourceArchitecturalAlternative <em>Source Architectural Alternative</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Source Architectural Alternative</em>' reference.
     * @see #getSourceArchitecturalAlternative()
     * @generated
     */
    void setSourceArchitecturalAlternative(ArchitecturalAlternative value);

    /**
     * Returns the value of the '<em><b>Changerequest</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Changerequest</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Changerequest</em>' reference.
     * @see #setChangerequest(ChangeRequest)
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getEffortAnalysisInstance_Changerequest()
     * @model required="true" ordered="false"
     * @generated
     */
	ChangeRequest getChangerequest();

	/**
     * Sets the value of the '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getChangerequest <em>Changerequest</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Changerequest</em>' reference.
     * @see #getChangerequest()
     * @generated
     */
	void setChangerequest(ChangeRequest value);

	/**
     * Returns the value of the '<em><b>Target Architectural Alternative</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target Architectural Alternative</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Target Architectural Alternative</em>' reference.
     * @see #setTargetArchitecturalAlternative(ArchitecturalAlternative)
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getEffortAnalysisInstance_TargetArchitecturalAlternative()
     * @model ordered="false"
     * @generated
     */
	ArchitecturalAlternative getTargetArchitecturalAlternative();

	/**
     * Sets the value of the '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getTargetArchitecturalAlternative <em>Target Architectural Alternative</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Target Architectural Alternative</em>' reference.
     * @see #getTargetArchitecturalAlternative()
     * @generated
     */
	void setTargetArchitecturalAlternative(ArchitecturalAlternative value);

	/**
     * Returns the value of the '<em><b>Maintainability Analysis Model</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getAnalysisinstances <em>Analysisinstances</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Maintainability Analysis Model</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Maintainability Analysis Model</em>' container reference.
     * @see #setMaintainabilityAnalysisModel(MaintainabilityAnalysisModel)
     * @see de.fzi.maintainabilitymodel.main.MainPackage#getEffortAnalysisInstance_MaintainabilityAnalysisModel()
     * @see de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel#getAnalysisinstances
     * @model opposite="analysisinstances" required="true" transient="false" ordered="false"
     * @generated
     */
	MaintainabilityAnalysisModel getMaintainabilityAnalysisModel();

	/**
     * Sets the value of the '{@link de.fzi.maintainabilitymodel.main.EffortAnalysisInstance#getMaintainabilityAnalysisModel <em>Maintainability Analysis Model</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Maintainability Analysis Model</em>' container reference.
     * @see #getMaintainabilityAnalysisModel()
     * @generated
     */
	void setMaintainabilityAnalysisModel(MaintainabilityAnalysisModel value);
	
	
} // EffortAnalysisInstance
