/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.architecturemodel.util;

import de.fzi.maintainabilitymodel.architecturemodel.*;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractCompositeComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractConnector;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractDatatype;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractOperation;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractOperationDefinition;
import de.fzi.maintainabilitymodel.architecturemodel.ArchitecturemodelPackage;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMCompositeComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMConnectorProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMDatatypeProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfacePortProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationDefinitionProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationProxy;
import de.fzi.maintainabilitymodel.main.Entity;
import de.fzi.maintainabilitymodel.main.NamedEntity;
import eu.qimpress.identifier.Identifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.maintainabilitymodel.architecturemodel.ArchitecturemodelPackage
 * @generated
 */
public class ArchitecturemodelSwitch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static ArchitecturemodelPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ArchitecturemodelSwitch() {
        if (modelPackage == null) {
            modelPackage = ArchitecturemodelPackage.eINSTANCE;
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	public T doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List<EClass> eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch(eSuperTypes.get(0), theEObject);
        }
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case ArchitecturemodelPackage.ABSTRACT_COMPONENT: {
                AbstractComponent abstractComponent = (AbstractComponent)theEObject;
                T result = caseAbstractComponent(abstractComponent);
                if (result == null) result = caseAbstractModelElement(abstractComponent);
                if (result == null) result = caseNamedEntity(abstractComponent);
                if (result == null) result = caseEntity(abstractComponent);
                if (result == null) result = caseIdentifier(abstractComponent);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_DATATYPE: {
                AbstractDatatype abstractDatatype = (AbstractDatatype)theEObject;
                T result = caseAbstractDatatype(abstractDatatype);
                if (result == null) result = caseAbstractModelElement(abstractDatatype);
                if (result == null) result = caseNamedEntity(abstractDatatype);
                if (result == null) result = caseEntity(abstractDatatype);
                if (result == null) result = caseIdentifier(abstractDatatype);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_INTERFACE: {
                AbstractInterface abstractInterface = (AbstractInterface)theEObject;
                T result = caseAbstractInterface(abstractInterface);
                if (result == null) result = caseAbstractModelElement(abstractInterface);
                if (result == null) result = caseNamedEntity(abstractInterface);
                if (result == null) result = caseEntity(abstractInterface);
                if (result == null) result = caseIdentifier(abstractInterface);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_INTERFACE_PORT: {
                AbstractInterfacePort abstractInterfacePort = (AbstractInterfacePort)theEObject;
                T result = caseAbstractInterfacePort(abstractInterfacePort);
                if (result == null) result = caseAbstractModelElement(abstractInterfacePort);
                if (result == null) result = caseNamedEntity(abstractInterfacePort);
                if (result == null) result = caseEntity(abstractInterfacePort);
                if (result == null) result = caseIdentifier(abstractInterfacePort);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_OPERATION_IMPLEMENTATION: {
                AbstractOperationImplementation abstractOperationImplementation = (AbstractOperationImplementation)theEObject;
                T result = caseAbstractOperationImplementation(abstractOperationImplementation);
                if (result == null) result = caseAbstractModelElement(abstractOperationImplementation);
                if (result == null) result = caseNamedEntity(abstractOperationImplementation);
                if (result == null) result = caseEntity(abstractOperationImplementation);
                if (result == null) result = caseIdentifier(abstractOperationImplementation);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_OPERATION_DEFINITION: {
                AbstractOperationDefinition abstractOperationDefinition = (AbstractOperationDefinition)theEObject;
                T result = caseAbstractOperationDefinition(abstractOperationDefinition);
                if (result == null) result = caseAbstractModelElement(abstractOperationDefinition);
                if (result == null) result = caseNamedEntity(abstractOperationDefinition);
                if (result == null) result = caseEntity(abstractOperationDefinition);
                if (result == null) result = caseIdentifier(abstractOperationDefinition);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_COMPONENT_PROXY: {
                SAMMComponentProxy sammComponentProxy = (SAMMComponentProxy)theEObject;
                T result = caseSAMMComponentProxy(sammComponentProxy);
                if (result == null) result = caseAbstractComponent(sammComponentProxy);
                if (result == null) result = caseAbstractModelElement(sammComponentProxy);
                if (result == null) result = caseNamedEntity(sammComponentProxy);
                if (result == null) result = caseEntity(sammComponentProxy);
                if (result == null) result = caseIdentifier(sammComponentProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_DATATYPE_PROXY: {
                SAMMDatatypeProxy sammDatatypeProxy = (SAMMDatatypeProxy)theEObject;
                T result = caseSAMMDatatypeProxy(sammDatatypeProxy);
                if (result == null) result = caseAbstractDatatype(sammDatatypeProxy);
                if (result == null) result = caseAbstractModelElement(sammDatatypeProxy);
                if (result == null) result = caseNamedEntity(sammDatatypeProxy);
                if (result == null) result = caseEntity(sammDatatypeProxy);
                if (result == null) result = caseIdentifier(sammDatatypeProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_INTERFACE_PROXY: {
                SAMMInterfaceProxy sammInterfaceProxy = (SAMMInterfaceProxy)theEObject;
                T result = caseSAMMInterfaceProxy(sammInterfaceProxy);
                if (result == null) result = caseAbstractInterface(sammInterfaceProxy);
                if (result == null) result = caseAbstractModelElement(sammInterfaceProxy);
                if (result == null) result = caseNamedEntity(sammInterfaceProxy);
                if (result == null) result = caseEntity(sammInterfaceProxy);
                if (result == null) result = caseIdentifier(sammInterfaceProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_INTERFACE_PORT_PROXY: {
                SAMMInterfacePortProxy sammInterfacePortProxy = (SAMMInterfacePortProxy)theEObject;
                T result = caseSAMMInterfacePortProxy(sammInterfacePortProxy);
                if (result == null) result = caseAbstractInterfacePort(sammInterfacePortProxy);
                if (result == null) result = caseAbstractModelElement(sammInterfacePortProxy);
                if (result == null) result = caseNamedEntity(sammInterfacePortProxy);
                if (result == null) result = caseEntity(sammInterfacePortProxy);
                if (result == null) result = caseIdentifier(sammInterfacePortProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_OPERATION_IMPLEMENTATION_PROXY: {
                SAMMOperationImplementationProxy sammOperationImplementationProxy = (SAMMOperationImplementationProxy)theEObject;
                T result = caseSAMMOperationImplementationProxy(sammOperationImplementationProxy);
                if (result == null) result = caseAbstractOperationImplementation(sammOperationImplementationProxy);
                if (result == null) result = caseAbstractModelElement(sammOperationImplementationProxy);
                if (result == null) result = caseNamedEntity(sammOperationImplementationProxy);
                if (result == null) result = caseEntity(sammOperationImplementationProxy);
                if (result == null) result = caseIdentifier(sammOperationImplementationProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_OPERATION_DEFINITION_PROXY: {
                SAMMOperationDefinitionProxy sammOperationDefinitionProxy = (SAMMOperationDefinitionProxy)theEObject;
                T result = caseSAMMOperationDefinitionProxy(sammOperationDefinitionProxy);
                if (result == null) result = caseAbstractOperationDefinition(sammOperationDefinitionProxy);
                if (result == null) result = caseAbstractModelElement(sammOperationDefinitionProxy);
                if (result == null) result = caseNamedEntity(sammOperationDefinitionProxy);
                if (result == null) result = caseEntity(sammOperationDefinitionProxy);
                if (result == null) result = caseIdentifier(sammOperationDefinitionProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_CONNECTOR: {
                AbstractConnector abstractConnector = (AbstractConnector)theEObject;
                T result = caseAbstractConnector(abstractConnector);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_CONNECTOR_PROXY: {
                SAMMConnectorProxy sammConnectorProxy = (SAMMConnectorProxy)theEObject;
                T result = caseSAMMConnectorProxy(sammConnectorProxy);
                if (result == null) result = caseAbstractConnector(sammConnectorProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_ARCHITECTURE_MODEL: {
                AbstractArchitectureModel abstractArchitectureModel = (AbstractArchitectureModel)theEObject;
                T result = caseAbstractArchitectureModel(abstractArchitectureModel);
                if (result == null) result = caseNamedEntity(abstractArchitectureModel);
                if (result == null) result = caseEntity(abstractArchitectureModel);
                if (result == null) result = caseIdentifier(abstractArchitectureModel);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_ARCHITECTURE_MODEL_PROXY: {
                SAMMArchitectureModelProxy sammArchitectureModelProxy = (SAMMArchitectureModelProxy)theEObject;
                T result = caseSAMMArchitectureModelProxy(sammArchitectureModelProxy);
                if (result == null) result = caseAbstractArchitectureModel(sammArchitectureModelProxy);
                if (result == null) result = caseNamedEntity(sammArchitectureModelProxy);
                if (result == null) result = caseEntity(sammArchitectureModelProxy);
                if (result == null) result = caseIdentifier(sammArchitectureModelProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_COMPOSITE_COMPONENT: {
                AbstractCompositeComponent abstractCompositeComponent = (AbstractCompositeComponent)theEObject;
                T result = caseAbstractCompositeComponent(abstractCompositeComponent);
                if (result == null) result = caseAbstractModelElement(abstractCompositeComponent);
                if (result == null) result = caseNamedEntity(abstractCompositeComponent);
                if (result == null) result = caseEntity(abstractCompositeComponent);
                if (result == null) result = caseIdentifier(abstractCompositeComponent);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.SAMM_COMPOSITE_COMPONENT_PROXY: {
                SAMMCompositeComponentProxy sammCompositeComponentProxy = (SAMMCompositeComponentProxy)theEObject;
                T result = caseSAMMCompositeComponentProxy(sammCompositeComponentProxy);
                if (result == null) result = caseAbstractCompositeComponent(sammCompositeComponentProxy);
                if (result == null) result = caseAbstractModelElement(sammCompositeComponentProxy);
                if (result == null) result = caseNamedEntity(sammCompositeComponentProxy);
                if (result == null) result = caseEntity(sammCompositeComponentProxy);
                if (result == null) result = caseIdentifier(sammCompositeComponentProxy);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ArchitecturemodelPackage.ABSTRACT_MODEL_ELEMENT: {
                AbstractModelElement abstractModelElement = (AbstractModelElement)theEObject;
                T result = caseAbstractModelElement(abstractModelElement);
                if (result == null) result = caseNamedEntity(abstractModelElement);
                if (result == null) result = caseEntity(abstractModelElement);
                if (result == null) result = caseIdentifier(abstractModelElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Component</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Component</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractComponent(AbstractComponent object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Model Element</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Model Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractModelElement(AbstractModelElement object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Datatype</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Datatype</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractDatatype(AbstractDatatype object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Interface Port</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Interface Port</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractInterfacePort(AbstractInterfacePort object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Operation Implementation</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Operation Implementation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAbstractOperationImplementation(AbstractOperationImplementation object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Operation Definition</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Operation Definition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractOperationDefinition(AbstractOperationDefinition object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Component Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Component Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMComponentProxy(SAMMComponentProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Datatype Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Datatype Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMDatatypeProxy(SAMMDatatypeProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Interface Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Interface Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMInterfaceProxy(SAMMInterfaceProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Interface Port Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Interface Port Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMInterfacePortProxy(SAMMInterfacePortProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Operation Implementation Proxy</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Operation Implementation Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSAMMOperationImplementationProxy(SAMMOperationImplementationProxy object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Operation Definition Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Operation Definition Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMOperationDefinitionProxy(SAMMOperationDefinitionProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Connector</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Connector</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractConnector(AbstractConnector object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Connector Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Connector Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMConnectorProxy(SAMMConnectorProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Architecture Model</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Architecture Model</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractArchitectureModel(AbstractArchitectureModel object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Architecture Model Proxy</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Architecture Model Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSAMMArchitectureModelProxy(SAMMArchitectureModelProxy object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Composite Component</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Composite Component</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAbstractCompositeComponent(AbstractCompositeComponent object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>SAMM Composite Component Proxy</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SAMM Composite Component Proxy</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSAMMCompositeComponentProxy(SAMMCompositeComponentProxy object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Interface</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Interface</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseAbstractInterface(AbstractInterface object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseIdentifier(Identifier object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseEntity(Entity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseNamedEntity(NamedEntity object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	public T defaultCase(EObject object) {
        return null;
    }

} //ArchitecturemodelSwitch
