/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.selectioncontainer.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.util.SelectioncontainerAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SelectioncontainerItemProviderAdapterFactory extends SelectioncontainerAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public SelectioncontainerItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
        supportedTypes.add(ITableItemLabelProvider.class);
        supportedTypes.add(ITableItemColorProvider.class);
        supportedTypes.add(ITableItemFontProvider.class);
        supportedTypes.add(IItemColorProvider.class);
        supportedTypes.add(IItemFontProvider.class);
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AbstractContainerItemProvider abstractContainerItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createAbstractContainerAdapter() {
        if (abstractContainerItemProvider == null) {
            abstractContainerItemProvider = new AbstractContainerItemProvider(this);
        }

        return abstractContainerItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComponentSelectionContainerItemProvider componentSelectionContainerItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createComponentSelectionContainerAdapter() {
        if (componentSelectionContainerItemProvider == null) {
            componentSelectionContainerItemProvider = new ComponentSelectionContainerItemProvider(this);
        }

        return componentSelectionContainerItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected InterfacePortSelectionContainerItemProvider interfacePortSelectionContainerItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createInterfacePortSelectionContainerAdapter() {
        if (interfacePortSelectionContainerItemProvider == null) {
            interfacePortSelectionContainerItemProvider = new InterfacePortSelectionContainerItemProvider(this);
        }

        return interfacePortSelectionContainerItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OperationImplementationSelectionContainerItemProvider operationImplementationSelectionContainerItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createOperationImplementationSelectionContainerAdapter() {
        if (operationImplementationSelectionContainerItemProvider == null) {
            operationImplementationSelectionContainerItemProvider = new OperationImplementationSelectionContainerItemProvider(this);
        }

        return operationImplementationSelectionContainerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DataTypeSelectionContainerItemProvider dataTypeSelectionContainerItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createDataTypeSelectionContainerAdapter() {
        if (dataTypeSelectionContainerItemProvider == null) {
            dataTypeSelectionContainerItemProvider = new DataTypeSelectionContainerItemProvider(this);
        }

        return dataTypeSelectionContainerItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationDefinitionSelectionContainer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OperationDefinitionSelectionContainerItemProvider operationDefinitionSelectionContainerItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationDefinitionSelectionContainer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createOperationDefinitionSelectionContainerAdapter() {
        if (operationDefinitionSelectionContainerItemProvider == null) {
            operationDefinitionSelectionContainerItemProvider = new OperationDefinitionSelectionContainerItemProvider(this);
        }

        return operationDefinitionSelectionContainerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CompositeComponentSelectionContainerItemProvider compositeComponentSelectionContainerItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCompositeComponentSelectionContainerAdapter() {
        if (compositeComponentSelectionContainerItemProvider == null) {
            compositeComponentSelectionContainerItemProvider = new CompositeComponentSelectionContainerItemProvider(this);
        }

        return compositeComponentSelectionContainerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CompositeTaskDerivationContainerItemProvider compositeTaskDerivationContainerItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createCompositeTaskDerivationContainerAdapter() {
        if (compositeTaskDerivationContainerItemProvider == null) {
            compositeTaskDerivationContainerItemProvider = new CompositeTaskDerivationContainerItemProvider(this);
        }

        return compositeTaskDerivationContainerItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected InterfaceSelectionContainerItemProvider interfaceSelectionContainerItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createInterfaceSelectionContainerAdapter() {
        if (interfaceSelectionContainerItemProvider == null) {
            interfaceSelectionContainerItemProvider = new InterfaceSelectionContainerItemProvider(this);
        }

        return interfaceSelectionContainerItemProvider;
    }

	/**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

	/**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

	/**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

	/**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

	/**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

	/**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

	/**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (abstractContainerItemProvider != null) abstractContainerItemProvider.dispose();
        if (componentSelectionContainerItemProvider != null) componentSelectionContainerItemProvider.dispose();
        if (interfacePortSelectionContainerItemProvider != null) interfacePortSelectionContainerItemProvider.dispose();
        if (operationImplementationSelectionContainerItemProvider != null) operationImplementationSelectionContainerItemProvider.dispose();
        if (interfaceSelectionContainerItemProvider != null) interfaceSelectionContainerItemProvider.dispose();
        if (dataTypeSelectionContainerItemProvider != null) dataTypeSelectionContainerItemProvider.dispose();
        if (operationDefinitionSelectionContainerItemProvider != null) operationDefinitionSelectionContainerItemProvider.dispose();
        if (compositeComponentSelectionContainerItemProvider != null) compositeComponentSelectionContainerItemProvider.dispose();
        if (compositeTaskDerivationContainerItemProvider != null) compositeTaskDerivationContainerItemProvider.dispose();
    }

}
