/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.maintainabilitymodel.workplan.util.WorkplanAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class WorkplanItemProviderAdapterFactory extends WorkplanAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkplanItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
        supportedTypes.add(ITableItemLabelProvider.class);
        supportedTypes.add(ITableItemColorProvider.class);
        supportedTypes.add(ITableItemFontProvider.class);
        supportedTypes.add(IItemColorProvider.class);
        supportedTypes.add(IItemFontProvider.class);
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ArchitecturalAlternativeItemProvider architecturalAlternativeItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createArchitecturalAlternativeAdapter() {
        if (architecturalAlternativeItemProvider == null) {
            architecturalAlternativeItemProvider = new ArchitecturalAlternativeItemProvider(this);
        }

        return architecturalAlternativeItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.ChangeRequest} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeRequestItemProvider changeRequestItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.ChangeRequest}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeRequestAdapter() {
        if (changeRequestItemProvider == null) {
            changeRequestItemProvider = new ChangeRequestItemProvider(this);
        }

        return changeRequestItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.Workplan} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WorkplanItemProvider workplanItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.Workplan}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createWorkplanAdapter() {
        if (workplanItemProvider == null) {
            workplanItemProvider = new WorkplanItemProvider(this);
        }

        return workplanItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.CompositeTask} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CompositeTaskItemProvider compositeTaskItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.CompositeTask}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createCompositeTaskAdapter() {
        if (compositeTaskItemProvider == null) {
            compositeTaskItemProvider = new CompositeTaskItemProvider(this);
        }

        return compositeTaskItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.TaskRationale} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TaskRationaleItemProvider taskRationaleItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.TaskRationale}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createTaskRationaleAdapter() {
        if (taskRationaleItemProvider == null) {
            taskRationaleItemProvider = new TaskRationaleItemProvider(this);
        }

        return taskRationaleItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workplan.Refactoring} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RefactoringItemProvider refactoringItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workplan.Refactoring}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createRefactoringAdapter() {
        if (refactoringItemProvider == null) {
            refactoringItemProvider = new RefactoringItemProvider(this);
        }

        return refactoringItemProvider;
    }

	/**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

	/**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

	/**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

	/**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

	/**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

	/**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

	/**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (architecturalAlternativeItemProvider != null) architecturalAlternativeItemProvider.dispose();
        if (changeRequestItemProvider != null) changeRequestItemProvider.dispose();
        if (workplanItemProvider != null) workplanItemProvider.dispose();
        if (compositeTaskItemProvider != null) compositeTaskItemProvider.dispose();
        if (taskRationaleItemProvider != null) taskRationaleItemProvider.dispose();
        if (refactoringItemProvider != null) refactoringItemProvider.dispose();
    }

}
