/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workplan.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.maintainabilitymodel.activity.adaptation.AdaptationFactory;
import de.fzi.maintainabilitymodel.activity.assembly.AssemblyFactory;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementationFactory;
import de.fzi.maintainabilitymodel.activity.repository.RepositoryFactory;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.WorkplanPackage;

/**
 * This is the item provider adapter for a {@link de.fzi.maintainabilitymodel.workplan.CompositeTask} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CompositeTaskItemProvider
	extends TaskItemProvider
	implements
		IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource, ITableItemLabelProvider, ITableItemColorProvider, ITableItemFontProvider, IItemColorProvider, IItemFontProvider {
	/**
     * This constructs an instance from a factory and a notifier.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CompositeTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

	/**
     * This returns the property descriptors for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);

        }
        return itemPropertyDescriptors;
    }

	/**
     * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
     * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
     * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (childrenFeatures == null) {
            super.getChildrenFeatures(object);
            childrenFeatures.add(WorkplanPackage.Literals.COMPOSITE_TASK__TASKRATIONALE);
            childrenFeatures.add(WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS);
        }
        return childrenFeatures;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
        // Check the type of the specified child object and return the proper feature to use for
        // adding (see {@link AddCommand}) it as a child.

        return super.getChildFeature(object, child);
    }

	/**
     * This returns CompositeTask.gif.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object getImage(Object object) {
        return overlayImage(object, getResourceLocator().getImage("full/obj16/CompositeTask"));
    }

	/**
     * This returns the label text for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getText(Object object) {
        String label = ((CompositeTask)object).getName();
        return label == null || label.length() == 0 ?
            getString("_UI_CompositeTask_type") :
            getString("_UI_CompositeTask_type") + " " + label;
    }

	/**
     * This handles model notifications by calling {@link #updateChildren} to update any cached
     * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void notifyChanged(Notification notification) {
        updateChildren(notification);

        switch (notification.getFeatureID(CompositeTask.class)) {
            case WorkplanPackage.COMPOSITE_TASK__TASKRATIONALE:
            case WorkplanPackage.COMPOSITE_TASK__SUBTASKS:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
        }
        super.notifyChanged(notification);
    }

	/**
     * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
     * that can be created under this object.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__TASKRATIONALE,
                 WorkplanFactory.eINSTANCE.createTaskRationale()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 WorkplanFactory.eINSTANCE.createCompositeTask()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 ImplementationFactory.eINSTANCE.createImplementComponentActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 ImplementationFactory.eINSTANCE.createImplementDataTypeActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createRemoveComponentActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createChangeInterfaceDefinitionActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createChangeComponentImplementationActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createChangeDataTypeActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createChangeComponentDefinitionActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createAddCompositeComponentActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createChangeCompositeComponentActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AdaptationFactory.eINSTANCE.createRemoveCompositeComponentActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 RepositoryFactory.eINSTANCE.createCompositeComponentActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AssemblyFactory.eINSTANCE.createInsertConnectorActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AssemblyFactory.eINSTANCE.createRemoveConnectorActivity()));

        newChildDescriptors.add
            (createChildParameter
                (WorkplanPackage.Literals.COMPOSITE_TASK__SUBTASKS,
                 AssemblyFactory.eINSTANCE.createInsertComponentActivity()));
    }

}
