/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.workorganisation.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.maintainabilitymodel.workorganisation.util.WorkorganisationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class WorkorganisationItemProviderAdapterFactory extends WorkorganisationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public WorkorganisationItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
        supportedTypes.add(ITableItemLabelProvider.class);
        supportedTypes.add(ITableItemColorProvider.class);
        supportedTypes.add(ITableItemFontProvider.class);
        supportedTypes.add(IItemColorProvider.class);
        supportedTypes.add(IItemFontProvider.class);
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.Person} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PersonItemProvider personItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.Person}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createPersonAdapter() {
        if (personItemProvider == null) {
            personItemProvider = new PersonItemProvider(this);
        }

        return personItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.Company} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CompanyItemProvider companyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.Company}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createCompanyAdapter() {
        if (companyItemProvider == null) {
            companyItemProvider = new CompanyItemProvider(this);
        }

        return companyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.Department} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DepartmentItemProvider departmentItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.Department}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createDepartmentAdapter() {
        if (departmentItemProvider == null) {
            departmentItemProvider = new DepartmentItemProvider(this);
        }

        return departmentItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.Team} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TeamItemProvider teamItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.Team}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createTeamAdapter() {
        if (teamItemProvider == null) {
            teamItemProvider = new TeamItemProvider(this);
        }

        return teamItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SoftwareArchitectItemProvider softwareArchitectItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSoftwareArchitectAdapter() {
        if (softwareArchitectItemProvider == null) {
            softwareArchitectItemProvider = new SoftwareArchitectItemProvider(this);
        }

        return softwareArchitectItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SoftwareDeveloperItemProvider softwareDeveloperItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSoftwareDeveloperAdapter() {
        if (softwareDeveloperItemProvider == null) {
            softwareDeveloperItemProvider = new SoftwareDeveloperItemProvider(this);
        }

        return softwareDeveloperItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WorkOrganisationModelItemProvider workOrganisationModelItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createWorkOrganisationModelAdapter() {
        if (workOrganisationModelItemProvider == null) {
            workOrganisationModelItemProvider = new WorkOrganisationModelItemProvider(this);
        }

        return workOrganisationModelItemProvider;
    }

	/**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

	/**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

	/**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

	/**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

	/**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

	/**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

	/**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (personItemProvider != null) personItemProvider.dispose();
        if (companyItemProvider != null) companyItemProvider.dispose();
        if (departmentItemProvider != null) departmentItemProvider.dispose();
        if (teamItemProvider != null) teamItemProvider.dispose();
        if (softwareArchitectItemProvider != null) softwareArchitectItemProvider.dispose();
        if (softwareDeveloperItemProvider != null) softwareDeveloperItemProvider.dispose();
        if (workOrganisationModelItemProvider != null) workOrganisationModelItemProvider.dispose();
    }

}
