/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.metrics.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.maintainabilitymodel.metrics.util.MetricsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MetricsItemProviderAdapterFactory extends MetricsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MetricsItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
        supportedTypes.add(ITableItemLabelProvider.class);
        supportedTypes.add(ITableItemColorProvider.class);
        supportedTypes.add(ITableItemFontProvider.class);
        supportedTypes.add(IItemColorProvider.class);
        supportedTypes.add(IItemFontProvider.class);
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.EffortMetric} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EffortMetricItemProvider effortMetricItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.EffortMetric}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createEffortMetricAdapter() {
        if (effortMetricItemProvider == null) {
            effortMetricItemProvider = new EffortMetricItemProvider(this);
        }

        return effortMetricItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.WorkloadMetric} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WorkloadMetricItemProvider workloadMetricItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.WorkloadMetric}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createWorkloadMetricAdapter() {
        if (workloadMetricItemProvider == null) {
            workloadMetricItemProvider = new WorkloadMetricItemProvider(this);
        }

        return workloadMetricItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.TimeMetric} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TimeMetricItemProvider timeMetricItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.TimeMetric}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createTimeMetricAdapter() {
        if (timeMetricItemProvider == null) {
            timeMetricItemProvider = new TimeMetricItemProvider(this);
        }

        return timeMetricItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.CostMetric} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CostMetricItemProvider costMetricItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.CostMetric}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createCostMetricAdapter() {
        if (costMetricItemProvider == null) {
            costMetricItemProvider = new CostMetricItemProvider(this);
        }

        return costMetricItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.TimeMeasure} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TimeMeasureItemProvider timeMeasureItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.TimeMeasure}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createTimeMeasureAdapter() {
        if (timeMeasureItemProvider == null) {
            timeMeasureItemProvider = new TimeMeasureItemProvider(this);
        }

        return timeMeasureItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.CostMeasure} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CostMeasureItemProvider costMeasureItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.CostMeasure}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createCostMeasureAdapter() {
        if (costMeasureItemProvider == null) {
            costMeasureItemProvider = new CostMeasureItemProvider(this);
        }

        return costMeasureItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.ComplexityMeasure} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComplexityMeasureItemProvider complexityMeasureItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.ComplexityMeasure}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createComplexityMeasureAdapter() {
        if (complexityMeasureItemProvider == null) {
            complexityMeasureItemProvider = new ComplexityMeasureItemProvider(this);
        }

        return complexityMeasureItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.metrics.Estimate} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EstimateItemProvider estimateItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.metrics.Estimate}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createEstimateAdapter() {
        if (estimateItemProvider == null) {
            estimateItemProvider = new EstimateItemProvider(this);
        }

        return estimateItemProvider;
    }

	/**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

	/**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

	/**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

	/**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

	/**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

	/**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

	/**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (effortMetricItemProvider != null) effortMetricItemProvider.dispose();
        if (workloadMetricItemProvider != null) workloadMetricItemProvider.dispose();
        if (timeMetricItemProvider != null) timeMetricItemProvider.dispose();
        if (costMetricItemProvider != null) costMetricItemProvider.dispose();
        if (estimateItemProvider != null) estimateItemProvider.dispose();
        if (timeMeasureItemProvider != null) timeMeasureItemProvider.dispose();
        if (costMeasureItemProvider != null) costMeasureItemProvider.dispose();
        if (complexityMeasureItemProvider != null) complexityMeasureItemProvider.dispose();
    }

}
