/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.main.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.fzi.maintainabilitymodel.architecturemodel.ArchitecturemodelFactory;
import de.fzi.maintainabilitymodel.main.MainFactory;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.metrics.MetricsFactory;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationFactory;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;

/**
 * This is the item provider adapter for a {@link de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MaintainabilityAnalysisModelItemProvider
	extends NamedEntityItemProvider
	implements
		IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource, ITableItemLabelProvider, ITableItemColorProvider, ITableItemFontProvider, IItemColorProvider, IItemFontProvider {
	/**
     * This constructs an instance from a factory and a notifier.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public MaintainabilityAnalysisModelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

	/**
     * This returns the property descriptors for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);

        }
        return itemPropertyDescriptors;
    }

	/**
     * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
     * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
     * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (childrenFeatures == null) {
            super.getChildrenFeatures(object);
            childrenFeatures.add(MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION);
            childrenFeatures.add(MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES);
            childrenFeatures.add(MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS);
            childrenFeatures.add(MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES);
            childrenFeatures.add(MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__METRICS);
            childrenFeatures.add(MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS);
        }
        return childrenFeatures;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
        // Check the type of the specified child object and return the proper feature to use for
        // adding (see {@link AddCommand}) it as a child.

        return super.getChildFeature(object, child);
    }

	/**
     * This returns MaintainabilityAnalysisModel.gif.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object getImage(Object object) {
        return overlayImage(object, getResourceLocator().getImage("full/obj16/MaintainabilityAnalysisModel"));
    }

	/**
     * This returns the label text for the adapted class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getText(Object object) {
        String label = ((MaintainabilityAnalysisModel)object).getName();
        return label == null || label.length() == 0 ?
            getString("_UI_MaintainabilityAnalysisModel_type") :
            getString("_UI_MaintainabilityAnalysisModel_type") + " " + label;
    }

	/**
     * This handles model notifications by calling {@link #updateChildren} to update any cached
     * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void notifyChanged(Notification notification) {
        updateChildren(notification);

        switch (notification.getFeatureID(MaintainabilityAnalysisModel.class)) {
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION:
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES:
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS:
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES:
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__METRICS:
            case MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
        }
        super.notifyChanged(notification);
    }

	/**
     * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
     * that can be created under this object.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__WORKORGANISATION,
                 WorkorganisationFactory.eINSTANCE.createWorkOrganisationModel()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES,
                 WorkplanFactory.eINSTANCE.createArchitecturalAlternative()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS,
                 WorkplanFactory.eINSTANCE.createChangeRequest()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__ANALYSISINSTANCES,
                 MainFactory.eINSTANCE.createEffortAnalysisInstance()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__METRICS,
                 MetricsFactory.eINSTANCE.createEffortMetric()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__METRICS,
                 MetricsFactory.eINSTANCE.createWorkloadMetric()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__METRICS,
                 MetricsFactory.eINSTANCE.createTimeMetric()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__METRICS,
                 MetricsFactory.eINSTANCE.createCostMetric()));

        newChildDescriptors.add
            (createChildParameter
                (MainPackage.Literals.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREMODELS,
                 ArchitecturemodelFactory.eINSTANCE.createSAMMArchitectureModelProxy()));
    }

}
