/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.architecturemodel.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.maintainabilitymodel.architecturemodel.util.ArchitecturemodelAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ArchitecturemodelItemProviderAdapterFactory extends ArchitecturemodelAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ArchitecturemodelItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
        supportedTypes.add(ITableItemLabelProvider.class);
        supportedTypes.add(ITableItemColorProvider.class);
        supportedTypes.add(ITableItemFontProvider.class);
        supportedTypes.add(IItemColorProvider.class);
        supportedTypes.add(IItemFontProvider.class);
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMComponentProxyItemProvider sammComponentProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMComponentProxyAdapter() {
        if (sammComponentProxyItemProvider == null) {
            sammComponentProxyItemProvider = new SAMMComponentProxyItemProvider(this);
        }

        return sammComponentProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMDatatypeProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMDatatypeProxyItemProvider sammDatatypeProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMDatatypeProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMDatatypeProxyAdapter() {
        if (sammDatatypeProxyItemProvider == null) {
            sammDatatypeProxyItemProvider = new SAMMDatatypeProxyItemProvider(this);
        }

        return sammDatatypeProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMInterfaceProxyItemProvider sammInterfaceProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMInterfaceProxyAdapter() {
        if (sammInterfaceProxyItemProvider == null) {
            sammInterfaceProxyItemProvider = new SAMMInterfaceProxyItemProvider(this);
        }

        return sammInterfaceProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfacePortProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMInterfacePortProxyItemProvider sammInterfacePortProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfacePortProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMInterfacePortProxyAdapter() {
        if (sammInterfacePortProxyItemProvider == null) {
            sammInterfacePortProxyItemProvider = new SAMMInterfacePortProxyItemProvider(this);
        }

        return sammInterfacePortProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationImplementationProxy} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SAMMOperationImplementationProxyItemProvider sammOperationImplementationProxyItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationImplementationProxy}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSAMMOperationImplementationProxyAdapter() {
        if (sammOperationImplementationProxyItemProvider == null) {
            sammOperationImplementationProxyItemProvider = new SAMMOperationImplementationProxyItemProvider(this);
        }

        return sammOperationImplementationProxyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationDefinitionProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMOperationDefinitionProxyItemProvider sammOperationDefinitionProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationDefinitionProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMOperationDefinitionProxyAdapter() {
        if (sammOperationDefinitionProxyItemProvider == null) {
            sammOperationDefinitionProxyItemProvider = new SAMMOperationDefinitionProxyItemProvider(this);
        }

        return sammOperationDefinitionProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMConnectorProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMConnectorProxyItemProvider sammConnectorProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMConnectorProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMConnectorProxyAdapter() {
        if (sammConnectorProxyItemProvider == null) {
            sammConnectorProxyItemProvider = new SAMMConnectorProxyItemProvider(this);
        }

        return sammConnectorProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SAMMArchitectureModelProxyItemProvider sammArchitectureModelProxyItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createSAMMArchitectureModelProxyAdapter() {
        if (sammArchitectureModelProxyItemProvider == null) {
            sammArchitectureModelProxyItemProvider = new SAMMArchitectureModelProxyItemProvider(this);
        }

        return sammArchitectureModelProxyItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.AbstractCompositeComponent} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AbstractCompositeComponentItemProvider abstractCompositeComponentItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.AbstractCompositeComponent}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAbstractCompositeComponentAdapter() {
        if (abstractCompositeComponentItemProvider == null) {
            abstractCompositeComponentItemProvider = new AbstractCompositeComponentItemProvider(this);
        }

        return abstractCompositeComponentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMCompositeComponentProxy} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SAMMCompositeComponentProxyItemProvider sammCompositeComponentProxyItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.architecturemodel.SAMMCompositeComponentProxy}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSAMMCompositeComponentProxyAdapter() {
        if (sammCompositeComponentProxyItemProvider == null) {
            sammCompositeComponentProxyItemProvider = new SAMMCompositeComponentProxyItemProvider(this);
        }

        return sammCompositeComponentProxyItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

	/**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

	/**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

	/**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

	/**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

	/**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

	/**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (sammComponentProxyItemProvider != null) sammComponentProxyItemProvider.dispose();
        if (sammDatatypeProxyItemProvider != null) sammDatatypeProxyItemProvider.dispose();
        if (sammInterfaceProxyItemProvider != null) sammInterfaceProxyItemProvider.dispose();
        if (sammInterfacePortProxyItemProvider != null) sammInterfacePortProxyItemProvider.dispose();
        if (sammOperationImplementationProxyItemProvider != null) sammOperationImplementationProxyItemProvider.dispose();
        if (sammOperationDefinitionProxyItemProvider != null) sammOperationDefinitionProxyItemProvider.dispose();
        if (sammConnectorProxyItemProvider != null) sammConnectorProxyItemProvider.dispose();
        if (sammArchitectureModelProxyItemProvider != null) sammArchitectureModelProxyItemProvider.dispose();
        if (abstractCompositeComponentItemProvider != null) abstractCompositeComponentItemProvider.dispose();
        if (sammCompositeComponentProxyItemProvider != null) sammCompositeComponentProxyItemProvider.dispose();
    }

}
