/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.fzi.maintainabilitymodel.activity.adaptation.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AdaptationItemProviderAdapterFactory extends AdaptationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public AdaptationItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
        supportedTypes.add(ITableItemLabelProvider.class);
        supportedTypes.add(ITableItemColorProvider.class);
        supportedTypes.add(ITableItemFontProvider.class);
        supportedTypes.add(IItemColorProvider.class);
        supportedTypes.add(IItemFontProvider.class);
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveComponentActivity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RemoveComponentActivityItemProvider removeComponentActivityItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveComponentActivity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRemoveComponentActivityAdapter() {
        if (removeComponentActivityItemProvider == null) {
            removeComponentActivityItemProvider = new RemoveComponentActivityItemProvider(this);
        }

        return removeComponentActivityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveCompositeComponentActivityRefinement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RemoveCompositeComponentActivityRefinementItemProvider removeCompositeComponentActivityRefinementItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveCompositeComponentActivityRefinement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRemoveCompositeComponentActivityRefinementAdapter() {
        if (removeCompositeComponentActivityRefinementItemProvider == null) {
            removeCompositeComponentActivityRefinementItemProvider = new RemoveCompositeComponentActivityRefinementItemProvider(this);
        }

        return removeCompositeComponentActivityRefinementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveComponentActivityRefinement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RemoveComponentActivityRefinementItemProvider removeComponentActivityRefinementItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveComponentActivityRefinement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRemoveComponentActivityRefinementAdapter() {
        if (removeComponentActivityRefinementItemProvider == null) {
            removeComponentActivityRefinementItemProvider = new RemoveComponentActivityRefinementItemProvider(this);
        }

        return removeComponentActivityRefinementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeInterfaceDefinitionActivityItemProvider changeInterfaceDefinitionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeInterfaceDefinitionActivityAdapter() {
        if (changeInterfaceDefinitionActivityItemProvider == null) {
            changeInterfaceDefinitionActivityItemProvider = new ChangeInterfaceDefinitionActivityItemProvider(this);
        }

        return changeInterfaceDefinitionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.AddOperationToInterfaceDefinitionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AddOperationToInterfaceDefinitionActivityItemProvider addOperationToInterfaceDefinitionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.AddOperationToInterfaceDefinitionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createAddOperationToInterfaceDefinitionActivityAdapter() {
        if (addOperationToInterfaceDefinitionActivityItemProvider == null) {
            addOperationToInterfaceDefinitionActivityItemProvider = new AddOperationToInterfaceDefinitionActivityItemProvider(this);
        }

        return addOperationToInterfaceDefinitionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.AddProvidedInterfaceToComponentDefinitionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AddProvidedInterfaceToComponentDefinitionActivityItemProvider addProvidedInterfaceToComponentDefinitionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.AddProvidedInterfaceToComponentDefinitionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createAddProvidedInterfaceToComponentDefinitionActivityAdapter() {
        if (addProvidedInterfaceToComponentDefinitionActivityItemProvider == null) {
            addProvidedInterfaceToComponentDefinitionActivityItemProvider = new AddProvidedInterfaceToComponentDefinitionActivityItemProvider(this);
        }

        return addProvidedInterfaceToComponentDefinitionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeComponentImplementationActivityItemProvider changeComponentImplementationActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeComponentImplementationActivityAdapter() {
        if (changeComponentImplementationActivityItemProvider == null) {
            changeComponentImplementationActivityItemProvider = new ChangeComponentImplementationActivityItemProvider(this);
        }

        return changeComponentImplementationActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeCompositeComponentActivityRefinement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChangeCompositeComponentActivityRefinementItemProvider changeCompositeComponentActivityRefinementItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeCompositeComponentActivityRefinement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createChangeCompositeComponentActivityRefinementAdapter() {
        if (changeCompositeComponentActivityRefinementItemProvider == null) {
            changeCompositeComponentActivityRefinementItemProvider = new ChangeCompositeComponentActivityRefinementItemProvider(this);
        }

        return changeCompositeComponentActivityRefinementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeDataTypeActivityItemProvider changeDataTypeActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeDataTypeActivityAdapter() {
        if (changeDataTypeActivityItemProvider == null) {
            changeDataTypeActivityItemProvider = new ChangeDataTypeActivityItemProvider(this);
        }

        return changeDataTypeActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeInterfaceportActivityItemProvider changeInterfaceportActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeInterfaceportActivityAdapter() {
        if (changeInterfaceportActivityItemProvider == null) {
            changeInterfaceportActivityItemProvider = new ChangeInterfaceportActivityItemProvider(this);
        }

        return changeInterfaceportActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.CreateNewComponentVersionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CreateNewComponentVersionActivityItemProvider createNewComponentVersionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.CreateNewComponentVersionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createCreateNewComponentVersionActivityAdapter() {
        if (createNewComponentVersionActivityItemProvider == null) {
            createNewComponentVersionActivityItemProvider = new CreateNewComponentVersionActivityItemProvider(this);
        }

        return createNewComponentVersionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeOperationImplementationActivityItemProvider changeOperationImplementationActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeOperationImplementationActivityAdapter() {
        if (changeOperationImplementationActivityItemProvider == null) {
            changeOperationImplementationActivityItemProvider = new ChangeOperationImplementationActivityItemProvider(this);
        }

        return changeOperationImplementationActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationFromInterfaceDefinitionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RemoveOperationFromInterfaceDefinitionActivityItemProvider removeOperationFromInterfaceDefinitionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationFromInterfaceDefinitionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createRemoveOperationFromInterfaceDefinitionActivityAdapter() {
        if (removeOperationFromInterfaceDefinitionActivityItemProvider == null) {
            removeOperationFromInterfaceDefinitionActivityItemProvider = new RemoveOperationFromInterfaceDefinitionActivityItemProvider(this);
        }

        return removeOperationFromInterfaceDefinitionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RemoveOperationImplementationActivityItemProvider removeOperationImplementationActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createRemoveOperationImplementationActivityAdapter() {
        if (removeOperationImplementationActivityItemProvider == null) {
            removeOperationImplementationActivityItemProvider = new RemoveOperationImplementationActivityItemProvider(this);
        }

        return removeOperationImplementationActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentDefinitionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeComponentDefinitionActivityItemProvider changeComponentDefinitionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentDefinitionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeComponentDefinitionActivityAdapter() {
        if (changeComponentDefinitionActivityItemProvider == null) {
            changeComponentDefinitionActivityItemProvider = new ChangeComponentDefinitionActivityItemProvider(this);
        }

        return changeComponentDefinitionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationDefinitionActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ChangeOperationDefinitionActivityItemProvider changeOperationDefinitionActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationDefinitionActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createChangeOperationDefinitionActivityAdapter() {
        if (changeOperationDefinitionActivityItemProvider == null) {
            changeOperationDefinitionActivityItemProvider = new ChangeOperationDefinitionActivityItemProvider(this);
        }

        return changeOperationDefinitionActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveInterfaceportActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RemoveInterfaceportActivityItemProvider removeInterfaceportActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveInterfaceportActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createRemoveInterfaceportActivityAdapter() {
        if (removeInterfaceportActivityItemProvider == null) {
            removeInterfaceportActivityItemProvider = new RemoveInterfaceportActivityItemProvider(this);
        }

        return removeInterfaceportActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveDataTypeImplementationActivity} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RemoveDataTypeImplementationActivityItemProvider removeDataTypeImplementationActivityItemProvider;

	/**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveDataTypeImplementationActivity}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter createRemoveDataTypeImplementationActivityAdapter() {
        if (removeDataTypeImplementationActivityItemProvider == null) {
            removeDataTypeImplementationActivityItemProvider = new RemoveDataTypeImplementationActivityItemProvider(this);
        }

        return removeDataTypeImplementationActivityItemProvider;
    }

	/**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.AddCompositeComponentActivity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AddCompositeComponentActivityItemProvider addCompositeComponentActivityItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.AddCompositeComponentActivity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAddCompositeComponentActivityAdapter() {
        if (addCompositeComponentActivityItemProvider == null) {
            addCompositeComponentActivityItemProvider = new AddCompositeComponentActivityItemProvider(this);
        }

        return addCompositeComponentActivityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.AddCompositeComponentActivityRefinement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AddCompositeComponentActivityRefinementItemProvider addCompositeComponentActivityRefinementItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.AddCompositeComponentActivityRefinement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAddCompositeComponentActivityRefinementAdapter() {
        if (addCompositeComponentActivityRefinementItemProvider == null) {
            addCompositeComponentActivityRefinementItemProvider = new AddCompositeComponentActivityRefinementItemProvider(this);
        }

        return addCompositeComponentActivityRefinementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeCompositeComponentActivity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChangeCompositeComponentActivityItemProvider changeCompositeComponentActivityItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.ChangeCompositeComponentActivity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createChangeCompositeComponentActivityAdapter() {
        if (changeCompositeComponentActivityItemProvider == null) {
            changeCompositeComponentActivityItemProvider = new ChangeCompositeComponentActivityItemProvider(this);
        }

        return changeCompositeComponentActivityItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveCompositeComponentActivity} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RemoveCompositeComponentActivityItemProvider removeCompositeComponentActivityItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.maintainabilitymodel.activity.adaptation.RemoveCompositeComponentActivity}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRemoveCompositeComponentActivityAdapter() {
        if (removeCompositeComponentActivityItemProvider == null) {
            removeCompositeComponentActivityItemProvider = new RemoveCompositeComponentActivityItemProvider(this);
        }

        return removeCompositeComponentActivityItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

	/**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

	/**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

	/**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

	/**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

	/**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

	/**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (removeComponentActivityItemProvider != null) removeComponentActivityItemProvider.dispose();
        if (removeCompositeComponentActivityRefinementItemProvider != null) removeCompositeComponentActivityRefinementItemProvider.dispose();
        if (removeComponentActivityRefinementItemProvider != null) removeComponentActivityRefinementItemProvider.dispose();
        if (changeInterfaceDefinitionActivityItemProvider != null) changeInterfaceDefinitionActivityItemProvider.dispose();
        if (addOperationToInterfaceDefinitionActivityItemProvider != null) addOperationToInterfaceDefinitionActivityItemProvider.dispose();
        if (addProvidedInterfaceToComponentDefinitionActivityItemProvider != null) addProvidedInterfaceToComponentDefinitionActivityItemProvider.dispose();
        if (changeComponentImplementationActivityItemProvider != null) changeComponentImplementationActivityItemProvider.dispose();
        if (changeCompositeComponentActivityRefinementItemProvider != null) changeCompositeComponentActivityRefinementItemProvider.dispose();
        if (changeDataTypeActivityItemProvider != null) changeDataTypeActivityItemProvider.dispose();
        if (changeInterfaceportActivityItemProvider != null) changeInterfaceportActivityItemProvider.dispose();
        if (createNewComponentVersionActivityItemProvider != null) createNewComponentVersionActivityItemProvider.dispose();
        if (changeOperationImplementationActivityItemProvider != null) changeOperationImplementationActivityItemProvider.dispose();
        if (removeOperationFromInterfaceDefinitionActivityItemProvider != null) removeOperationFromInterfaceDefinitionActivityItemProvider.dispose();
        if (removeOperationImplementationActivityItemProvider != null) removeOperationImplementationActivityItemProvider.dispose();
        if (changeComponentDefinitionActivityItemProvider != null) changeComponentDefinitionActivityItemProvider.dispose();
        if (changeOperationDefinitionActivityItemProvider != null) changeOperationDefinitionActivityItemProvider.dispose();
        if (removeInterfaceportActivityItemProvider != null) removeInterfaceportActivityItemProvider.dispose();
        if (removeDataTypeImplementationActivityItemProvider != null) removeDataTypeImplementationActivityItemProvider.dispose();
        if (addCompositeComponentActivityItemProvider != null) addCompositeComponentActivityItemProvider.dispose();
        if (addCompositeComponentActivityRefinementItemProvider != null) addCompositeComponentActivityRefinementItemProvider.dispose();
        if (changeCompositeComponentActivityItemProvider != null) changeCompositeComponentActivityItemProvider.dispose();
        if (removeCompositeComponentActivityItemProvider != null) removeCompositeComponentActivityItemProvider.dispose();
    }

}
