package de.fzi.maintainability.wizards;

import java.io.IOException;
import java.util.List;

import de.fzi.maintainability.wizard.MaintainabilityModelReader;
import de.fzi.maintainability.wizard.SAMMReader;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;

public class WorkplanDerivationManager {

	private String systemFilePath;
	private String repositoryFilePath;
	
	private SAMMReader sammReader;


	private MaintainabilityModelReader maintReader;
	
	public void setArchitectureModelFilePaths(String systemFilePath, String repositoryFilePath) {
		if (systemFilePath == null) {
			return;
		}
		if (systemFilePath.equals("")) {
			return;
		}
		
		this.systemFilePath = systemFilePath;
		this.repositoryFilePath = repositoryFilePath;
		
		try {
			sammReader = new SAMMReader();
			
			sammReader.loadFile(this.systemFilePath);
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public ServiceArchitectureModel getServiceArchitectureModel() {
		if (sammReader == null) {
			return null;
		}
		return sammReader.getServiceArchitectureModel();
	}
	
	public void initializeWorkplanModel() {
		
		try {
			maintReader = new MaintainabilityModelReader();
		
			maintReader.initializeAnalysisModel();
		
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		

	}
	
	public void addChangeRequestDescription() {
		
	}
	
	public void deleteChangeRequestDescription() {
		
	}

	public void alterChangeRequestDescription() {
		
	}

	public List getChangeRequestDescriptions() {
		return null;
	}

	
	public void saveWorkplanModelToFile(String filename) {
		
	}

	public SAMMReader getSammReader() {
		return sammReader;
	}

	public void setSammReader(SAMMReader sammReader) {
		this.sammReader = sammReader;
	}

}
