package de.fzi.maintainability.wizards;

import java.util.List;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class SelectArchitectureArtefactsWizardPage extends WizardPage {

	private WorkplanDerivationManager workplanDerivationManager;
	private Tree tree;

	
	protected SelectArchitectureArtefactsWizardPage(String pageName, WorkplanDerivationManager workplanDerivationManager) {
		super(pageName);
	    setTitle("Select Affected Architecture Elements");
	    setDescription("Select Affected Elements of Architecture");
	    this.workplanDerivationManager = workplanDerivationManager;

	}

	@Override
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 1;
		layout.verticalSpacing = 9;

		Label label = new Label(container, SWT.NULL);
		label.setText("Select affected elements of architecture:");

	    GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
		data.heightHint = 200;
		data.widthHint = 300;
		
		tree = new Tree(container, SWT.CHECK | SWT.BORDER);
		//tree.setItemCount(20);
		tree.setLayoutData(data);
		
		setControl(container);
	}

	public void initialize() {
		System.out.println("intialize components list");
		List<SubcomponentInstance> components = this.workplanDerivationManager.getSammReader().getComponents();
		
		// map: item -> entity ?
		
		for (SubcomponentInstance comp : components) {
			TreeItem compItem = new TreeItem(tree, SWT.NONE);
			compItem.setText(comp.getName());

			// TODO: correct implementation
			List<InterfacePort> interfacePorts = null; // this.workplanDerivationManager.getSammReader().getInterfacesOfComponent(comp);
			
			for (InterfacePort interfacePort : interfacePorts) {
				String interfaceName = "Port: "+ interfacePort.getName() + " InterfaceType: " + interfacePort.getInterfaceType().getName();
				TreeItem interfaceItem = new TreeItem(compItem, SWT.NONE);
				interfaceItem.setText(interfaceName);
			}
			
		}
	}
}
