package de.fzi.maintainability.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;

public class DetermineActivityKindWizardPage extends WizardPage {

	private WorkplanDerivationManager workplanDerivationManager;

	protected DetermineActivityKindWizardPage(String pageName, WorkplanDerivationManager workplanDerivationManager) {
		super(pageName);
	    setTitle("Determine Kind Of Activity");
	    setDescription("Determine Kind of Activity");
	    this.workplanDerivationManager = workplanDerivationManager;

	}

	@Override
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 1;
		layout.verticalSpacing = 9;

		Label label = new Label(container, SWT.NULL);
		label.setText("Determine Kind of Activity:");

		Tree tree = new Tree(container, SWT.CHECK | SWT.BORDER);
		tree.setItemCount(20);
		
		setControl(container);

	}
}
