package de.fzi.maintainability.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ChangeRequestSpecificationWizardPage extends WizardPage {

	private WorkplanDerivationManager workplanDerivationManager;

	protected ChangeRequestSpecificationWizardPage(String pageName, WorkplanDerivationManager workplanDerivationManager) {
		super(pageName);
	    setTitle("Specify Change Requests");
	    setDescription("Enter Change Request Specifications");
	    this.workplanDerivationManager = workplanDerivationManager;
	}

	@Override
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 1;
		
		layout.verticalSpacing = 9;
		Label label = new Label(container, SWT.NULL);
		label.setText("Change Requests:");
		setControl(container);
		
		
	    Table table = new Table(container, SWT.BORDER);
	    
	    GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
		data.heightHint = 200;
		table.setLayoutData(data);
	    
	    TableColumn column_crname = new TableColumn(table, SWT.LEFT);
	    column_crname.setText("Name");
	    column_crname.setWidth(200);
	    TableColumn column_desc =  new TableColumn(table, SWT.LEFT);
	    column_desc.setText("Description"); 
	    column_desc.setWidth(200);
	    table.setHeaderVisible(true);
	    
	    TableItem item = new TableItem(table, SWT.NULL);
	    item.setText(0, "HI");
	    item.setText(1, "Du");
	    
	    Button button = new Button(container, SWT.PUSH);
		button.setText("Add Change Request");
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleAddChangeRequest();
			}
		});


	}

	protected void handleAddChangeRequest() {
		
		//MultipleInputDialog dialog = MultipleInputDialog();
		
	}

}
