package de.fzi.maintainability.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ArchitectureModelSelectionWizardPage extends WizardPage {

	private WorkplanDerivationManager workplanDerivationManager;
	
	private Text systemFileText;
	private IFile systemFile;

	private Text repositoryFileText;
	private IFile repositoryFile;

	protected ArchitectureModelSelectionWizardPage(String pageName, WorkplanDerivationManager workplanDerivationManager) {
		super(pageName);
	    setTitle("Select Architecture Model Files");
	    setDescription("Please select files for SAM Repository and SAM System " +
	    		"which represent your Target Model");
	    this.workplanDerivationManager = workplanDerivationManager;
	
	}

	
	@Override
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		
		Label label = new Label(container, SWT.NULL);
		label.setText("SAM &System File:");

		systemFileText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		systemFileText.setLayoutData(gd);
		systemFileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		systemFileText.setEditable(false);

		Button button = new Button(container, SWT.PUSH);
		button.setText("Browse Workspace...");
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowseSystemFile();
			}
		});
		
		label = new Label(container, SWT.NULL);
		label.setText("SAM &Repository File:");

		repositoryFileText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		repositoryFileText.setLayoutData(gd);
		repositoryFileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		repositoryFileText.setEditable(false);

		button = new Button(container, SWT.PUSH);
		button.setText("Browse Workspace...");
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowseRepositoryFile();
			}
		});

		//dialogChanged();
		setControl(container);

	}

	/**
	 * Uses the standard container selection dialog to choose the new value for
	 * the container field.
	 */

	private void handleBrowseSystemFile() {
		IFile[] result = WorkspaceResourceDialog.openFileSelection(getShell(), "Select SAM System File", "Select SAM System model file", false, null, null);
		
		if (result.length > 0) {
			systemFile = result[0];
			systemFileText.setText(result[0].getFullPath().toString());
		}
}

	/**
	 * Uses the standard container selection dialog to choose the new value for
	 * the container field.
	 */

	private void handleBrowseRepositoryFile() {
		IFile[] result = WorkspaceResourceDialog.openFileSelection(getShell(), "Select SAM Repository File", "Select SAM Repository File", false, null, null);
		
		if (result.length > 0) {
			repositoryFile = result[0];
			repositoryFileText.setText(result[0].getFullPath().toString());
		}
	}

	
	/**
	 * Ensures that both text fields are set.
	 */

	private void dialogChanged() {
		/*
		IResource container = ResourcesPlugin.getWorkspace().getRoot()
				.findMember(new Path(getContainerName()));
		String fileName = getFileName();

		if (getContainerName().length() == 0) {
			updateStatus("File container must be specified");
			return;
		}
		if (container == null
				|| (container.getType() & (IResource.PROJECT | IResource.FOLDER)) == 0) {
			updateStatus("File container must exist");
			return;
		}
		if (!container.isAccessible()) {
			updateStatus("Project must be writable");
			return;
		}
		if (fileName.length() == 0) {
			updateStatus("File name must be specified");
			return;
		}
		if (fileName.replace('\\', '/').indexOf('/', 1) > 0) {
			updateStatus("File name must be valid");
			return;
		}
		int dotLoc = fileName.lastIndexOf('.');
		if (dotLoc != -1) {
			String ext = fileName.substring(dotLoc + 1);
			if (ext.equalsIgnoreCase("maint") == false) {
				updateStatus("File extension must be \"maint\"");
				return;
			}
		}
		updateStatus(null);
		*/
		System.out.println("DialogChanged");
		
		if (this.getSystemFilePath() != null) {
			System.out.println("SystemFilePath: "+ this.getSystemFilePath().toString());
			this.workplanDerivationManager.setArchitectureModelFilePaths(this.getSystemFilePath().toString(), "");
		}
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

	public String getSystemFilePath() {
		return ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + this.systemFileText.getText();
	}

	public String getRepositoryFilePath() {
		return ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + this.repositoryFileText.getText();
	}

}
