package de.fzi.maintainability.wizard;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

import eu.qimpress.identifier.impl.IdentifierPackageImpl;
import eu.qimpress.samm.annotation.impl.AnnotationPackageImpl;
import eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl;
import eu.qimpress.samm.core.impl.CorePackageImpl;
import eu.qimpress.samm.datatypes.impl.DatatypesPackageImpl;
import eu.qimpress.samm.deployment.allocation.impl.AllocationPackageImpl;
import eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl;
import eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl;
import eu.qimpress.samm.usagemodel.impl.UsagemodelPackageImpl;

public class SAMMReader {

	private java.io.File file;
	
	private Resource resourceSAMM;
	
	private ResourceSet resourceSet;
	
	private ServiceArchitectureModel samRoot;
	
	public SAMMReader() throws IOException {

		AnnotationPackageImpl.eINSTANCE.eClass();
		CorePackageImpl.eINSTANCE.eClass();
		BehaviourPackageImpl.eINSTANCE.eClass();
		DatatypesPackageImpl.eINSTANCE.eClass();
		StaticstructurePackageImpl.eINSTANCE.eClass();
		UsagemodelPackageImpl.eINSTANCE.eClass();
		AllocationPackageImpl.eINSTANCE.eClass();
		HardwarePackageImpl.eINSTANCE.eClass();
		TargetenvironmentPackageImpl.eINSTANCE.eClass();
		//Expression-------------------------------
		IdentifierPackageImpl.eINSTANCE.eClass();

		// setup resource set
		resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
		.put("xml", new XMLResourceFactoryImpl());
		resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
		.put("staticstructure", new XMLResourceFactoryImpl());

	}

	public void loadFile(String filename) throws IOException {
		// check file existence
		file = new java.io.File(filename);
		if(!file.exists()){
			throw new FileNotFoundException("File \"" + filename + "\" does not exist.");
		}

		URI fileGAST = URI.createFileURI(filename);

		// setup resource
		resourceSAMM = new XMLResourceImpl(fileGAST);

		Map loadOptions = ((XMLResourceImpl)resourceSAMM).getDefaultLoadOptions();
		loadOptions.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_DEPRECATED_METHODS, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_PARSER_POOL, new XMLParserPoolImpl());
		loadOptions.put(XMLResource.OPTION_USE_XML_NAME_TO_FEATURE_MAP, new HashMap());

		((ResourceImpl)resourceSAMM).setIntrinsicIDToEObjectMap(new HashMap());
		
		/*
		 * load GAST
		 */		
		resourceSAMM.load(loadOptions);
		
		resourceSet = resourceSAMM.getResourceSet();
		System.out.println("resourceSAMM loaded");
		
		getServiceArchitectureModel();
		
		EcoreUtil.resolveAll(this.resourceSet);
	}
	
	private void loadRepositoryFile(URI fileuri) {

		this.resourceSet.getResource(fileuri, false);

	}
	
	public ServiceArchitectureModel getServiceArchitectureModel() {
		if (resourceSAMM != null) {
			if (samRoot != null) {
				return samRoot;
			} else {
			
				Iterator<EObject> itr = resourceSAMM.getAllContents();
				
				while (itr.hasNext()) {
					EObject obj = itr.next();
					
					if (obj instanceof ServiceArchitectureModel) {
						System.out.println("SAM Root detected!");
						samRoot = (ServiceArchitectureModel) obj;
						return (ServiceArchitectureModel) obj;
					}
				}
				
				return null;
			}
		} else {
			return null;
		}
	}
	
	public List<SubcomponentInstance> getComponents() {
		
		System.out.println("getComponents");
		if (this.getServiceArchitectureModel() != null) {
			return this.getServiceArchitectureModel().getSubcomponents();
		}
		
		return null;
	}

	public List<InterfacePort> getInterfacesOfComponent(SubcomponentInstance componentInstance) throws FileNotFoundException {
		
		ComponentType compType = componentInstance.getRealizedBy();
		
		System.out.println("getInterfaces:" + compType.getName());
		
		EObject compTypeR = null;
		if (compType.eIsProxy()) {
			System.out.println("comptype is proxy!");
			
		    URI proxyURI = ((InternalEObject)compType).eProxyURI();
		    String filename= proxyURI.toFileString();
		    
			loadRepositoryFile(proxyURI);
			java.io.File file2 = new java.io.File(filename);
			if(!file2.exists()){
				throw new FileNotFoundException("File \"" + filename + "\" does not exist.");
			}

			URI fileURI = URI.createFileURI(filename);
			
			this.resourceSet.getResource(fileURI, false);

			EcoreUtil.resolve(compType, this.resourceSet);
		}
		
		List<InterfacePort> providedInterfacePorts = compType.getProvided();

		return providedInterfacePorts;

		/*
		for (InterfacePort interfacePort : providedInterfacePorts) {
			interfacePort.getInterfaceType().getName();
		}
		*/
	}
	

}
