package de.fzi.maintainability.wizard;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

import de.fzi.maintainabilitymodel.activity.adaptation.impl.AdaptationPackageImpl;
import de.fzi.maintainabilitymodel.activity.allocation.impl.AllocationPackageImpl;
import de.fzi.maintainabilitymodel.activity.assembly.impl.AssemblyPackageImpl;
import de.fzi.maintainabilitymodel.activity.implementation.impl.ImplementationPackageImpl;
import de.fzi.maintainabilitymodel.activity.repository.impl.RepositoryPackageImpl;
import de.fzi.maintainabilitymodel.activity.reusage.impl.ReusagePackageImpl;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MainFactory;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.main.impl.MainPackageImpl;
import de.fzi.maintainabilitymodel.metrics.impl.MetricsPackageImpl;
import de.fzi.maintainabilitymodel.workorganisation.impl.WorkorganisationPackageImpl;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.impl.WorkplanPackageImpl;
import eu.qimpress.identifier.impl.IdentifierPackageImpl;

public class MaintainabilityModelReader {

	private java.io.File file;
	
	private Resource resourceMaint;
	
	private ResourceSet resourceSet;
	
	private MaintainabilityAnalysisModel maintainabilityAnalysisModel;
	private EffortAnalysisInstance effortAnalysisInstance;
	private Workplan workplan;
	
	public Workplan getWorkplan() {
		return workplan;
	}

	public MaintainabilityModelReader() throws IOException {

		MainPackageImpl.eINSTANCE.eClass();
		MetricsPackageImpl.eINSTANCE.eClass();
		WorkorganisationPackageImpl.eINSTANCE.eClass();
		WorkplanPackageImpl.eINSTANCE.eClass();
		AdaptationPackageImpl.eINSTANCE.eClass();
		AllocationPackageImpl.eINSTANCE.eClass();
		AssemblyPackageImpl.eINSTANCE.eClass();
	    ImplementationPackageImpl.eINSTANCE.eClass();
		RepositoryPackageImpl.eINSTANCE.eClass();
		ReusagePackageImpl.eINSTANCE.eClass();
		//Expression-------------------------------
		IdentifierPackageImpl.eINSTANCE.eClass();

		// setup resource set
		resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put("maint", new XMLResourceFactoryImpl());
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
		.put("xml", new XMLResourceFactoryImpl());

	}

	public void loadFile(String filename) throws IOException {
		// check file existence
		file = new java.io.File(filename);
		if(!file.exists()){
			throw new FileNotFoundException("File \"" + filename + "\" does not exist.");
		}

		URI fileMAINT = URI.createFileURI(filename);

		// setup resource
		resourceMaint = new XMLResourceImpl(fileMAINT);

		Map loadOptions = ((XMLResourceImpl)resourceMaint).getDefaultLoadOptions();
		loadOptions.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_DEPRECATED_METHODS, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_PARSER_POOL, new XMLParserPoolImpl());
		loadOptions.put(XMLResource.OPTION_USE_XML_NAME_TO_FEATURE_MAP, new HashMap());

		((ResourceImpl)resourceMaint).setIntrinsicIDToEObjectMap(new HashMap());
		
		/*
		 * load GAST
		 */		
		resourceMaint.load(loadOptions);
	}

	public Resource getResourceMaint() {
		return resourceMaint;
	}

	public void save() throws IOException {
		this.getResourceMaint().save(null);
	}
	
	public void saveAs(String filename) throws IOException {

		this.getResourceMaint().setURI(URI.createFileURI(filename));
		this.getResourceMaint().save(null);

	}
	
	public void initializeAnalysisModel() {
		
		maintainabilityAnalysisModel = MainFactory.eINSTANCE.createMaintainabilityAnalysisModel();
		
		effortAnalysisInstance = MainFactory.eINSTANCE.createEffortAnalysisInstance();
		
		maintainabilityAnalysisModel.getAnalysisinstances().add(effortAnalysisInstance);
		
		workplan = WorkplanFactory.eINSTANCE.createWorkplan();
		
		effortAnalysisInstance.setWorkplan(workplan);
	}


}
