package de.fzi.kamp.ui.workplanediting.switches.followupview;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveDataTypeImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;

public class FoUpHasChildrenAdaptationSwitch extends AdaptationSwitch<boolean[]> {
    private final static Logger logger = Logger.getLogger(FoUpHasChildrenAdaptationSwitch.class);

    /**
     * Here an array of booleans has to be used, because an single 
     * boolean cannot be returned by the switch.
     */
    private boolean[] hasCildren = { false };

    @Override
    public boolean[] caseChangeDataTypeActivity(ChangeDataTypeActivity changeDataTypeActivity) {
        if (!changeDataTypeActivity.getFollowups().isEmpty()) {
            this.hasCildren[0] = true;
        }
        return this.hasCildren;
    }
    
    @Override
    public boolean[] caseChangeInterfaceDefinitionActivity(
            ChangeInterfaceDefinitionActivity changeInterfaceDefinitionActivity) {
        if (!changeInterfaceDefinitionActivity.getFollowups().isEmpty()) {
            this.hasCildren[0] = true;
        }
        return this.hasCildren;
    }

    @Override
    public boolean[] caseChangeInterfaceportActivity(ChangeInterfaceportActivity object) {
        if (!object.getRefinements().isEmpty()) {
            this.hasCildren[0] = true;
        }
        return this.hasCildren;
    }
    
    @Override
    public boolean[] caseRemoveDataTypeImplementationActivity(
    		RemoveDataTypeImplementationActivity object) {
    	this.hasCildren[0] = false;
    	return this.hasCildren;
    }
    
    @Override
    public boolean[] defaultCase(EObject object) {
    	FoUpHasChildrenImplementationSwitch childrenImplementationSwitch = 
    		new FoUpHasChildrenImplementationSwitch(this.hasCildren);
        return childrenImplementationSwitch.doSwitch(object);
    }
}
