package de.fzi.kamp.ui.workplanediting.switches.followupview;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;

public class FoUpAdaptationContentSwitch extends AdaptationSwitch<Object[]> {
    private final static Logger logger = Logger.getLogger(FoUpAdaptationContentSwitch.class);

    @Override
    public Object[] caseChangeDataTypeActivity(ChangeDataTypeActivity changeDataTypeActivity) {
        return changeDataTypeActivity.getFollowups().toArray();
    }

    @Override
    public Object[] caseChangeInterfaceDefinitionActivity(
            ChangeInterfaceDefinitionActivity changeInterfaceDefinitionActivity) {
        return changeInterfaceDefinitionActivity.getFollowups().toArray();
    }

    @Override
    public Object[] caseChangeInterfaceportActivity(ChangeInterfaceportActivity changeInterfaceportActivity) {
        if (!changeInterfaceportActivity.getRefinements().isEmpty()) {
            return changeInterfaceportActivity.getRefinements().toArray();
        }
        return new Object[] {};
    }

    @Override
    public Object[] defaultCase(EObject object) {
        return new Object[] {};
    }
}
