package de.fzi.kamp.ui.workplanediting.switches.followupview;

import java.util.List;

import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationFromInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;
import de.fzi.maintainabilitymodel.activity.repository.DatatypeActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfaceActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfacePortActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;

public class FilterFollowAdaptationUpActivitiesSwitch extends AdaptationSwitch<Activity> {
	
	private List<Activity> filteredActivities;
	
	public FilterFollowAdaptationUpActivitiesSwitch(List<Activity> filteredActivities) {
		this.filteredActivities = filteredActivities;
	}
	
	@Override
	public Activity caseInterfaceActivity(InterfaceActivity object) {
		this.filteredActivities.add(object);
		return object;
	}
	
	@Override
	public Activity caseDatatypeActivity(DatatypeActivity object) {
		this.filteredActivities.add(object);
		return object;
	}
	
	@Override
	public Activity caseInterfacePortActivity(InterfacePortActivity object) {
		this.filteredActivities.add(object);
		return object;
	}
		
	@Override
	public Activity caseChangeOperationImplementationActivity(
			ChangeOperationImplementationActivity object) {
		this.filteredActivities.add(object);
		return object;	}
	
	//TODO Adapt. At the moment ChangeOperationDefinitionActivity does not inherit Activity!!!!
//	@Override
//	public Activity caseChangeOperationDefinitionActivity(
//			ChangeOperationDefinitionActivity object) {
//		this.filteredActivities.add(object);
//		return object;
//	}
	
	@Override
	public Activity caseRemoveOperationFromInterfaceDefinitionActivity(
			RemoveOperationFromInterfaceDefinitionActivity object) {
		this.filteredActivities.add(object);
		return object;
	}
	
	@Override
	public Activity caseRemoveOperationImplementationActivity(
			RemoveOperationImplementationActivity object) {
		this.filteredActivities.add(object);
		return object;
	}	
	
	@Override
	public Activity defaultCase(EObject object) {
		FilterFollowUpImplementationSwitch filterImplementationActivities = 
			new FilterFollowUpImplementationSwitch(this.filteredActivities);
		filterImplementationActivities.doSwitch(object);
		return (Activity)object;
	}
}
