package de.fzi.kamp.ui.workplanediting.switches.containmentview;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.implementation.util.ImplementationSwitch;

public class ContHasChildrenImplementationSwitch extends ImplementationSwitch<boolean[]> {
    private final static Logger logger = Logger.getLogger(ContHasChildrenImplementationSwitch.class);

    boolean[] hasChildren = { false };

    @Override
    public boolean[] caseImplementComponentActivity(ImplementComponentActivity implementComponentActivity) {
        if (!implementComponentActivity.getRefinements().isEmpty()) {
            this.hasChildren[0] = true;
        }
        return this.hasChildren;
    }

    @Override
    public boolean[] caseImplementProvidedInterfaceportActivity(
            ImplementProvidedInterfaceportActivity implementProvidedInterfaceportActivity) {
        if (!implementProvidedInterfaceportActivity.getRefinements().isEmpty()) {
            this.hasChildren[0] = true;
        }
        return this.hasChildren;
    }

    @Override
    public boolean[] defaultCase(EObject object) {
        return this.hasChildren;
    }

}
