package de.fzi.kamp.ui.workplanediting.switches.containmentview;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;

public class ContHasChildrenAdaptationSwitch extends AdaptationSwitch<boolean[]> {
    private final static Logger logger = Logger.getLogger(ContHasChildrenAdaptationSwitch.class);

    boolean[] hasChildren = { false };

    @Override
    public boolean[] caseChangeComponentImplementationActivity(
            ChangeComponentImplementationActivity changeComponentImplementationActivity) {
        if (!changeComponentImplementationActivity.getRefinements().isEmpty()) {
            this.hasChildren[0] = true;
        }
        return this.hasChildren;
    }

    @Override
    public boolean[] caseChangeInterfaceportActivity(ChangeInterfaceportActivity changeInterfaceportActivity) {
        logger.trace("caseChangeInterfaceportActivity");
        if (!changeInterfaceportActivity.getRefinements().isEmpty()) {
            this.hasChildren[0] = true;
        }
        return this.hasChildren;
    }

    @Override
    public boolean[] caseChangeInterfaceDefinitionActivity(
            ChangeInterfaceDefinitionActivity changeInterfaceDefinitionActivity) {
        return this.hasChildren;
    }

    @Override
    public boolean[] caseChangeDataTypeActivity(ChangeDataTypeActivity object) {
        return this.hasChildren;
    }

    @Override
    public boolean[] defaultCase(EObject object) {
        logger.trace("defaultCase");
        ContHasChildrenImplementationSwitch implementationSwitch = new ContHasChildrenImplementationSwitch();
        return implementationSwitch.doSwitch(object);
    }
}
