package de.fzi.kamp.ui.workplanediting.switches.containmentview;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.implementation.util.ImplementationSwitch;
import de.fzi.maintainabilitymodel.workplan.Activity;

public class ContContentImplementationSwitch extends ImplementationSwitch<Activity[]> {
    private final static Logger logger = Logger.getLogger(ContContentImplementationSwitch.class);

    @Override
    public Activity[] caseImplementComponentActivity(ImplementComponentActivity implementComponentActivity) {
        int size = implementComponentActivity.getRefinements().size();
        return implementComponentActivity.getRefinements().toArray(new Activity[size]);
    }

    @Override
    public Activity[] caseImplementProvidedInterfaceportActivity(
            ImplementProvidedInterfaceportActivity implementProvidedInterfaceportActivity) {
        int size = implementProvidedInterfaceportActivity.getRefinements().size();
        return implementProvidedInterfaceportActivity.getRefinements().toArray(new Activity[size]);
    }

    @Override
    public Activity[] defaultCase(EObject object) {
        ContContentAdaptationSwitch adaptionContentSwitch = new ContContentAdaptationSwitch();
        adaptionContentSwitch.doSwitch((Activity) object);
        return new Activity[] {};
    }

}
