package de.fzi.kamp.ui.workplanediting.switches.containmentview;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.activity.adaptation.ChangeComponentImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;

public class ContContentAdaptationSwitch extends AdaptationSwitch<Object[]> {
    private final static Logger logger = Logger.getLogger(ContContentAdaptationSwitch.class);

    @Override
    public Object[] caseChangeComponentImplementationActivity(
            ChangeComponentImplementationActivity changeComponentImplementationActivity) {
        return changeComponentImplementationActivity.getRefinements().toArray();
    }

    @Override
    public Object[] caseChangeInterfaceportActivity(ChangeInterfaceportActivity changeInterfaceportActivity) {
        return changeInterfaceportActivity.getRefinements().toArray();
    }

    @Override
    public Object[] caseChangeDataTypeActivity(ChangeDataTypeActivity object) {
        // In containment view any refinements are displayed for DataTypes and InterfaceDefinitions
        return new Object[] {};
    }

    @Override
    public Object[] caseChangeInterfaceDefinitionActivity(ChangeInterfaceDefinitionActivity object) {
        // In containment view any refinements are displayed for DataTypes and InterfaceDefinitions
        return new Object[] {};
    }

    @Override
    public Object[] defaultCase(EObject object) {
        return new Object[] {};
    }
}
