package de.fzi.kamp.ui.workplanediting.provider.switches;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;

import de.fzi.kamp.ui.activator.Activator;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementComponentActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementProvidedInterfaceportActivity;
import de.fzi.maintainabilitymodel.activity.implementation.util.ImplementationSwitch;
import de.fzi.maintainabilitymodel.activity.repository.InterfaceActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfacePortActivity;

public class IconImplementationSwitch extends ImplementationSwitch<ImageDescriptor> {
	
	 private static final Logger logger = Logger.getLogger(IconImplementationSwitch.class);
	 
	 private boolean returnSignatureChangeIcon;
	 
	 public IconImplementationSwitch(boolean returnSignatureChangeIcon) {
		this.returnSignatureChangeIcon = returnSignatureChangeIcon;
	}
	
	@Override
	public ImageDescriptor caseImplementComponentActivity(
			ImplementComponentActivity object) {
		logger.debug("ImplementComponent case reached.");
		if(this.returnSignatureChangeIcon){
			return null;
		}else{
			return Activator.getImageDescriptor("/icons/PrimitiveComponent.gif");
		}		
	}
	
	@Override
	public ImageDescriptor caseImplementProvidedInterfaceportActivity(
			ImplementProvidedInterfaceportActivity object) {
		if(this.returnSignatureChangeIcon){
			return IconAdaptationSwitch.getSignatureChangeIcon(object.isSignaturechange());
		}else{
			return Activator.getImageDescriptor("/icons/ProvidedInterfacePort.gif");
		}
	}
		
	@Override
	public ImageDescriptor caseInterfacePortActivity(
			InterfacePortActivity object) {
		if(this.returnSignatureChangeIcon){
			return IconAdaptationSwitch.getSignatureChangeIcon(object.isSignaturechange());
		}else{
			return Activator.getImageDescriptor("/icons/RequiredInterfacePort.gif");
		}
	}
	
	@Override
	public ImageDescriptor caseImplementOperationActivity(
			ImplementOperationActivity object) {
		if(this.returnSignatureChangeIcon){
			return IconAdaptationSwitch.getSignatureChangeIcon(object.isSignaturechange());
		}else{
			return Activator.getImageDescriptor("/icons/Operation.gif");
		}		
	}
	
	@Override
	public ImageDescriptor caseInterfaceActivity(InterfaceActivity object) {
		if(this.returnSignatureChangeIcon){
			return null;
		}else{
			return Activator.getImageDescriptor("/icons/Interface.gif");
		}
	}
	
	@Override
	public ImageDescriptor caseImplementDataTypeActivity(
			ImplementDataTypeActivity object) {
		if(this.returnSignatureChangeIcon){
			return null;
		}else{
			return Activator.getImageDescriptor("/icons/PrimitiveDataType.gif");
		}
	}
}
