package de.fzi.kamp.ui.workplanediting.provider.switches;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;

import de.fzi.kamp.ui.activator.Activator;
import de.fzi.maintainabilitymodel.activity.adaptation.util.AdaptationSwitch;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.activity.repository.DatatypeActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfaceActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfacePortActivity;
import de.fzi.maintainabilitymodel.activity.repository.OperationImplementationActivity;

/**
 * This switch is just the beginning of a chain of switches. If an element
 * cannot be handled by this switch (no adaptation element), in the default 
 * case the element is delegated to another switch handling  
 * another switch handling
 * @author tknapp
 *
 */

public class IconAdaptationSwitch extends AdaptationSwitch<ImageDescriptor> {
    private static final Logger logger = Logger.getLogger(IconAdaptationSwitch.class);
    private boolean returnSignatureChangeIcon = false;

    @Override
    public ImageDescriptor caseComponentActivity(ComponentActivity object) {
        if (returnSignatureChangeIcon) {
            return null;
        } else {
            return Activator.getImageDescriptor("/icons/PrimitiveComponent.gif");
        }
    }

    @Override
    public ImageDescriptor caseDatatypeActivity(DatatypeActivity object) {
        if (returnSignatureChangeIcon) {
            return null;
        } else {
            return Activator.getImageDescriptor("/icons/PrimitiveDataType.gif");
        }
    }

    @Override
    public ImageDescriptor caseInterfaceActivity(InterfaceActivity object) {
        if (returnSignatureChangeIcon) {
            return null;
        } else {
            return Activator.getImageDescriptor("/icons/Interface.gif");
        }
    }

    @Override
    public ImageDescriptor caseInterfacePortActivity(InterfacePortActivity object) {

        if (returnSignatureChangeIcon) {
            return getSignatureChangeIcon(object.isSignaturechange());
        } else {
            return getImageForInterfacePort(((InterfacePortActivity) object).getInterfaceport().isRequired());
        }
    }
    
    @Override
    public ImageDescriptor caseOperationImplementationActivity(
    		OperationImplementationActivity object) {
    	 if (returnSignatureChangeIcon) {
             return getSignatureChangeIcon(object.isSignaturechange());
         } else {
             return Activator.getImageDescriptor("/icons/Operation.gif");
         }
    }       
    
    @Override
    public ImageDescriptor defaultCase(EObject object) {
        logger.debug("Default case in icon switch has been reached with object: " + object);
        
        IconImplementationSwitch implementationSwitch = new IconImplementationSwitch(this.returnSignatureChangeIcon);
             
        return implementationSwitch.doSwitch(object);
    }

    private static ImageDescriptor getImageForInterfacePort(boolean isRequired) {
        if (isRequired) {
            return Activator.getImageDescriptor("/icons/RequiredInterfacePort.gif");
        } else {
            return Activator.getImageDescriptor("/icons/ProvidedInterfacePort.gif");
        }
    }

    public static ImageDescriptor getSignatureChangeIcon(boolean isSignatureChange) {
        if (isSignatureChange) {
            return Activator.getImageDescriptor("/icons/button_accept22.png");
        } else {
            return Activator.getImageDescriptor("/icons/fileclose22.png");
        }
    }

    public void setReturnSignatureChangeIcon(boolean returnSignatureChangeIcon) {
        this.returnSignatureChangeIcon = returnSignatureChangeIcon;
    }
}
