package de.fzi.kamp.ui.workplanediting.provider;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;

import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;

public class WorkorganisationContentProvider extends AdapterFactoryContentProvider {
    private final static Logger logger = Logger.getLogger(WorkorganisationContentProvider.class);

    public WorkorganisationContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object[] getElements(Object object) {

        if (object instanceof ResourceSet) {
            return getWorkorganisationModel(((ResourceSet) object).getAllContents()).toArray();
        }
        return new Object[] {};
    }

    public List<WorkOrganisationModel> getWorkorganisationModel(TreeIterator<Notifier> resourceIterator) {
        List<WorkOrganisationModel> workorganisationModels = new LinkedList<WorkOrganisationModel>();

        while (resourceIterator.hasNext()) {
            Object next = resourceIterator.next();
            if (next instanceof WorkOrganisationModel) {
                workorganisationModels.add((WorkOrganisationModel) next);
            }
        }
        return workorganisationModels;
    }
}