package de.fzi.kamp.ui.workplanediting.provider;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.activity.repository.DatatypeActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfaceActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfacePortActivity;
import de.fzi.maintainabilitymodel.activity.repository.OperationActivity;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;

public class WorkPlanTreeLabelProvider implements ITableLabelProvider, ITableFontProvider {
    private final static Logger logger = Logger.getLogger(WorkPlanTreeLabelProvider.class);

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
		if (element instanceof CompositeTask) {
			return null;
		}
		if (columnIndex == WorkplanTableColumnConstants.COLUMN_TREE) {
			return ActivityImageProvider.getImageForActivity(element);
		} else if (columnIndex == WorkplanTableColumnConstants.COLUMN_ISSIGNATURECHANGE) {
			return ActivityImageProvider.getIconForSignatureChange(element);
		}
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == WorkplanTableColumnConstants.COLUMN_TREE) {
            return "";
        }

        if (element instanceof Workplan) {
            return "Workplan";
        }

        if (element instanceof CompositeTask) {
            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ACTIVITYSTRUCTURETYPE:
                return "Composite Activity";
            case WorkplanTableColumnConstants.COLUMN_COMPONENT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_INTERFACEPORT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_ARCHITECTUREELEMENTNAME:
                if ((element!=null)&&(((CompositeTask) element).getTaskrationale()!=null))
                    return ((CompositeTask) element).getTaskrationale().getKeyword();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_BASICACTIVITY:
                return "";
            case WorkplanTableColumnConstants.COLUMN_OPERATION:
                return "";
            case WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE:
                return "";
            }
        }

        if (element instanceof ComponentActivity) {
            ComponentSelectionContainer container = (ComponentSelectionContainer) ((Activity) element)
                    .getSelectioncontainer();

            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ACTIVITYSTRUCTURETYPE:
                return "Component";
            case WorkplanTableColumnConstants.COLUMN_COMPONENT:
                return ((ComponentActivity) element).getComponent().getName();
            case WorkplanTableColumnConstants.COLUMN_ARCHITECTUREELEMENTNAME:
                return ((ComponentActivity) element).getComponent().getName();
            case WorkplanTableColumnConstants.COLUMN_BASICACTIVITY:
                if ((container!=null)&&(container.getBasicActivity()!=null))
                    return container.getBasicActivity().toString();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_INTERFACEPORT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_OPERATION:
                return "";
            case WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE:
                AbstractComponent abstractComponent = ((ComponentActivity) element).getComponent();
                return buildWorkorganisationElementString(abstractComponent);
            }
        }

        if (element instanceof InterfacePortActivity) {
            InterfacePortSelectionContainer iportContainer = (InterfacePortSelectionContainer) ((Activity) element)
                    .getSelectioncontainer();

            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ACTIVITYSTRUCTURETYPE:
                return "Interface Port";
            case WorkplanTableColumnConstants.COLUMN_COMPONENT:
                return iportContainer.getParent().getComponenttype().getName();
            case WorkplanTableColumnConstants.COLUMN_INTERFACEPORT:
                return iportContainer.getInterfaceport().getName();
            case WorkplanTableColumnConstants.COLUMN_ARCHITECTUREELEMENTNAME:
                return ((InterfacePortActivity) element).getInterfaceport().getName();
            case WorkplanTableColumnConstants.COLUMN_BASICACTIVITY:
                if ((iportContainer!=null)&&(iportContainer.getBasicActivity()!=null))
                    return iportContainer.getBasicActivity().toString();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_OPERATION:
                return "";
            case WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE:
                return handleWOElementsPresentationInLowestAbstractionView(element, iportContainer);
            }
        }

        //TODO: Adapt also to Operation Definition Selection Container. Otherwise class cast exceptions could be thrown.
        if (element instanceof OperationActivity) {
            OperationImplementationSelectionContainer container = (OperationImplementationSelectionContainer) ((Activity) element)
                    .getSelectioncontainer();
            InterfacePortSelectionContainer iportContainer = container.getParent();

            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ACTIVITYSTRUCTURETYPE:
                return "Operation";
            case WorkplanTableColumnConstants.COLUMN_COMPONENT:
                return iportContainer.getParent().getComponenttype().getName();
            case WorkplanTableColumnConstants.COLUMN_INTERFACEPORT:
                return iportContainer.getInterfaceport().getName();
            case WorkplanTableColumnConstants.COLUMN_ARCHITECTUREELEMENTNAME:
                return ((OperationActivity) element).getOperation().getName();
            case WorkplanTableColumnConstants.COLUMN_BASICACTIVITY:
                if ((container!=null)&&(container.getBasicActivity()!=null))
                    return container.getBasicActivity().toString();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_OPERATION:
                return container.getOperation().getName();
            case WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE:
                return handleWOElementsPresentationInLowestAbstractionView(element, iportContainer);
            default:
                return "";
            }
        }

        if (element instanceof DatatypeActivity) {
            DataTypeSelectionContainer container = (DataTypeSelectionContainer) ((Activity) element)
                    .getSelectioncontainer();

            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ACTIVITYSTRUCTURETYPE:
                return "Datatype Definition";
            case WorkplanTableColumnConstants.COLUMN_COMPONENT:
                return "";

            case WorkplanTableColumnConstants.COLUMN_ARCHITECTUREELEMENTNAME:
                if ((element!=null)&&(((DatatypeActivity) element).getDatatype()!=null))
                    return ((DatatypeActivity) element).getDatatype().getName();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_BASICACTIVITY:
                if ((container!=null)&&(container.getBasicActivity()!=null))
                    return container.getBasicActivity().toString();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_INTERFACEPORT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_OPERATION:
                return "";
            case WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE:
                return "";
            }
        }

        if ((element instanceof InterfaceActivity) && (!(element instanceof InterfacePortActivity))) {
            InterfaceSelectionContainer container = (InterfaceSelectionContainer) ((Activity) element)
                    .getSelectioncontainer();

            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ACTIVITYSTRUCTURETYPE:
                return "Interface";
            case WorkplanTableColumnConstants.COLUMN_ARCHITECTUREELEMENTNAME:
                if ((element!=null)&&(((InterfaceActivity) element).getAinterface()!=null))
                    return ((InterfaceActivity) element).getAinterface().getName();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_BASICACTIVITY:
                if ((container!=null)&&(container.getBasicActivity()!=null))
                    return container.getBasicActivity().toString();
                else return "?";
            case WorkplanTableColumnConstants.COLUMN_COMPONENT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_INTERFACEPORT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_OPERATION:
                return "";
            case WorkplanTableColumnConstants.COLUMN_DEVELOPERSTRUCTURE:
                return "";
            }
        }

        if (element instanceof Activity) {
            switch (columnIndex) {
            case WorkplanTableColumnConstants.COLUMN_ESTIMATEDTIMEEFFORT:
                return "";
            case WorkplanTableColumnConstants.COLUMN_ACCUMULATEDTIMEEFFORT:
                return Double.toString(((Activity) element).getAggregatedTimeEstimate());
                // case WorkplanTableColumnConstants.CAPTION_COLUMN_DEVELOPERSTRUCTURE: return
                // ((Activity)element).get
                // TODO: Add the developer mapping in the label provider
            }
        }

        return "";
    }

    /**
     * Concatenates all workorganisation elements assigned to a component to one string. Every
     * workorganisation element gets an annotation, whether it is a "Team", a "Developer" or an
     * "Architect".
     * 
     * @param element
     *            The element coming into the label provider.
     * @param container
     *            The selection container of the corresponding component.
     * @return All workorganisation elements in one string.
     */
    public String buildWorkorganisationElementString(AbstractComponent abstractComponent) {
        String WOelementsString = "";
        for (WorkOrganisationElement WOelement : abstractComponent.getWorkorganisationelement()) {

            if (WOelementsString.isEmpty())
                WOelementsString = WOelementsString + WOelement.getName();
            else
                WOelementsString = WOelementsString + ", " + WOelement.getName();
            if (WOelement instanceof Team)
                WOelementsString += " (Team)";
            if (WOelement instanceof SoftwareDeveloper)
                WOelementsString += " (Developer)";
            if (WOelement instanceof SoftwareArchitect)
                WOelementsString += " (Architect)";
        }
        return WOelementsString;
    }

    /**
     * The handling of the string which is displayed for an operation in the developer structure
     * column is swaped in an own method, because it has to be overwritten for the the lowest
     * abstraction view.
     */
    public String handleWOElementsPresentationInLowestAbstractionView(Object element,
            InterfacePortSelectionContainer iportContainer) {
        return "";
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof Activity
                && property.equals(WorkplanTableColumnConstants.CAPTION_COLUMN_ACCUMULATEDTIMEEFFORT))
            return true;
        else
            return false;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
    }

    @Override
    public Font getFont(Object element, int columnIndex) {
        if (element instanceof CompositeTask)
            return SurfaceFactory.getFontStyle().getBold(SurfaceFactory.STYLE_ANSWER);
        else
            return SurfaceFactory.getFontStyle().get(SurfaceFactory.STYLE_ANSWER);
    }
}
