package de.fzi.kamp.ui.workplanediting.provider;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.fzi.kamp.ui.workplanediting.switches.followupview.FilterFollowAdaptationUpActivitiesSwitch;
import de.fzi.kamp.ui.workplanediting.switches.followupview.FoUpAdaptationContentSwitch;
import de.fzi.kamp.ui.workplanediting.switches.followupview.FoUpHasChildrenAdaptationSwitch;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeDataTypeActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeInterfaceDefinitionActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Task;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class WorkPlanFollowUpContentProvider implements ITreeContentProvider {
    private final static Logger logger = Logger.getLogger(WorkPlanFollowUpContentProvider.class);

    @Override
    public Object[] getChildren(Object parentElement) {

//        if (parentElement instanceof CompositeTask) {
            return filterWorkplanListToFollowUpRoots((CompositeTask) parentElement).toArray();
//        }
        //With the new switch above, this code never should be passed again.
//        FoUpAdaptationContentSwitch getChildrenSwitch = new FoUpAdaptationContentSwitch();
//        return getChildrenSwitch.doSwitch((EObject) parentElement);
    }

    @Override
    public Object getParent(Object element) {

        return null;
    }

    @Override
    public boolean hasChildren(Object element) {

        if (element instanceof CompositeTask)
            return !((CompositeTask) element).getSubtasks().isEmpty();

        FoUpHasChildrenAdaptationSwitch hasChildrenSwitch = new FoUpHasChildrenAdaptationSwitch();
        return hasChildrenSwitch.doSwitch((EObject) element)[0];
    }

    @Override
    public Object[] getElements(Object inputElement) {

        if (inputElement instanceof Workplan) {
            return ((Workplan) inputElement).getTasks().toArray();
        }
        return new Object[] {};
    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub

    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub

    }

    private List<Activity> filterWorkplanListToFollowUpRoots(CompositeTask compositeTask) {
        List<Activity> filteredActivities = new ArrayList<Activity>();
        FilterFollowAdaptationUpActivitiesSwitch filterSwitch = new FilterFollowAdaptationUpActivitiesSwitch(filteredActivities);
        for (Task task : compositeTask.getSubtasks()) {
        	if(task instanceof CompositeTask){
        		//The case that the workplan root has been given to this filter method.
        		//Then just the composite activities are added.
        		filteredActivities.add(task);
        	}else{
        		filterSwitch.doSwitch(task);
        	}
        }
        return filteredActivities;
    }

}
