package de.fzi.kamp.ui.workplanediting.provider;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.fzi.kamp.ui.workplanediting.switches.containmentview.ContContentAdaptationSwitch;
import de.fzi.kamp.ui.workplanediting.switches.containmentview.ContContentImplementationSwitch;
import de.fzi.kamp.ui.workplanediting.switches.containmentview.ContHasChildrenAdaptationSwitch;
import de.fzi.kamp.ui.workplanediting.switches.containmentview.ContHasChildrenImplementationSwitch;
import de.fzi.maintainabilitymodel.activity.adaptation.AdaptationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementationActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class WorkPlanContainmentContentProvider implements ITreeContentProvider {
    private final static Logger logger = Logger.getLogger(WorkPlanContainmentContentProvider.class);

    @Override
    public Object[] getChildren(Object parentElement) {

        if (parentElement instanceof Workplan) {
            return ((Workplan) parentElement).getTasks().toArray();
        }

        if (parentElement instanceof CompositeTask) {
            return ((CompositeTask) parentElement).getSubtasks().toArray();
        }

        // The switch queries the remaining types of activities
        Assert.isTrue(parentElement instanceof Activity);

        // FIXME: adaptation switch only covers adaptation activities!!!
        if (parentElement instanceof AdaptationActivity) {
            ContContentAdaptationSwitch adaptationSwitch = new ContContentAdaptationSwitch();
            return adaptationSwitch.doSwitch((Activity) parentElement);
        }

        if (parentElement instanceof ImplementationActivity) {
            ContContentImplementationSwitch implementationSwitch = new ContContentImplementationSwitch();
            return implementationSwitch.doSwitch((Activity) parentElement);
        }
        
        return null;
    }

    @Override
    public Object getParent(Object element) {
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {

        if (element instanceof Workplan) {
            return true;
        }

        if (element instanceof CompositeTask) {
            return !((CompositeTask) element).getSubtasks().isEmpty();
        }

        if (element instanceof AdaptationActivity) {
            ContHasChildrenAdaptationSwitch adaptationSwitch = new ContHasChildrenAdaptationSwitch();
            return adaptationSwitch.doSwitch((Activity) element)[0];
        }

        if (element instanceof ImplementationActivity) {
            ContHasChildrenImplementationSwitch implementationSwitch = new ContHasChildrenImplementationSwitch();
            return implementationSwitch.doSwitch((Activity) element)[0];
        }
        
        logger.error("Element not covered: "+ element.toString());
        return false;
    }

    @Override
    public Object[] getElements(Object inputElement) {

        if (inputElement instanceof Workplan) {
            return ((Workplan) inputElement).getTasks().toArray();

        }
        return null;
    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub

    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub

    }

}
