package de.fzi.kamp.ui.workplanediting.provider;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;

public class LowestAbstractionLabelProvider extends WorkPlanTreeLabelProvider {
    private final static Logger logger = Logger.getLogger(LowestAbstractionLabelProvider.class);

    /**
     * In the lowest abstraction view combined with the developer structure the operations have the
     * workorganisation element which was assigned to it's parent component.
     */
    @Override
    public String handleWOElementsPresentationInLowestAbstractionView(Object element,
            InterfacePortSelectionContainer iportContainer) {
        if (iportContainer.getParent() != null)
            return super.buildWorkorganisationElementString(iportContainer.getParent().getComponenttype());
        else
            return "";
    }
}
