package de.fzi.kamp.ui.workplanediting.provider;

import java.util.LinkedList;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class LowestAbstractionContentProvider implements ITreeContentProvider {
    private final static Logger logger = Logger.getLogger(LowestAbstractionContentProvider.class);

    @Override
    public Object[] getChildren(Object parentElement) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Object getParent(Object element) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof Workplan)
            return true;
        else
            return false;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Workplan) {
            LinkedList<Object> elements = new LinkedList<Object>();
            eliminateDoubledElements(getLeaves(inputElement, elements));
            return elements.toArray();
        } else
            return null;
    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub

    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub

    }

    private LinkedList<Object> getLeaves(Object element, LinkedList<Object> elements) {
        if (element instanceof EObject) {
            EObject eelement = (EObject) element;

            TreeIterator<EObject> treeitr = eelement.eAllContents();

            while (treeitr.hasNext()) {
                EObject obj = treeitr.next();

                if (obj.eContents().isEmpty()) {
                    if (obj instanceof Activity)
                        elements.add(obj);
                }
            }
        }
        return elements;
    }

    private void eliminateDoubledElements(LinkedList<Object> elements) {

        if (elements != null) {
            for (Object currentActivity : elements) {
                for (Object listElement : elements) {
                    int index1 = elements.indexOf(currentActivity);
                    int index2 = elements.indexOf(listElement);
                    if (currentActivity.equals(listElement) && index1 != index2)
                        elements.remove(listElement);
                }
            }
        }
    }
}
