package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class WorkplanFollowUpButtonListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(WorkplanFollowUpButtonListener.class);

    private CentralEditorPage editorPage;
    private Tree tree;

    public WorkplanFollowUpButtonListener(CentralEditorPage editorPage, Tree tree) {
        this.editorPage = editorPage;
        this.tree = tree;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (tree.getData() instanceof Workplan) {
            this.editorPage.updateWorkplanTree((Workplan) tree.getData(), true, false, false);
        }
        super.widgetSelected(e);
    }
}
