package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.maineditor.ICentralEditorPage;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class LowestAbstractionListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(LowestAbstractionListener.class);

    private ICentralEditorPage page;
    private Tree tree;
    private Button lowestAbstracttion;
    private Button developerStructure;

    public LowestAbstractionListener(ICentralEditorPage page, Tree tree, Button lowestAbstracttion,
            Button developerStructure) {
        super();
        this.page = page;
        this.tree = tree;
        this.lowestAbstracttion = lowestAbstracttion;
        this.developerStructure = developerStructure;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        if (tree.getData() instanceof Workplan) {
            this.page.updateWorkplanTree((Workplan) tree.getData(), false, true, lowestAbstracttion.getSelection());
            this.page.showDeveloperStructure(this.developerStructure.getSelection());
        }

        super.widgetSelected(e);
    }

}
