package de.fzi.kamp.ui.workplanediting.listeners;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EffortEstimationEnterListener implements KeyListener {
    private final static Logger logger = Logger.getLogger(EffortEstimationEnterListener.class);

    private List<Control> controls;
    private Text text;

    public EffortEstimationEnterListener(List<Control> controls, Text text) {
        this.controls = controls;
        this.text = text;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.keyCode == SWT.KEYPAD_CR || e.character == SWT.CR) {
            int indexOfNextElement = controls.indexOf(text) + 1;
            if (indexOfNextElement < controls.size()) {
                Text nextControl = (Text) controls.get(indexOfNextElement);
                if (nextControl.setFocus())
                    nextControl.selectAll();
            }
        }

    }

    @Override
    public void keyReleased(KeyEvent e) {
        // TODO Auto-generated method stub

    }
}
