package de.fzi.kamp.ui.workplanediting.listeners;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.kamp.service.commands.EditTimeEffortCommand;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.workplan.Activity;

public class EditableTimeEffortModifyListener implements ModifyListener {
    private final static Logger logger = Logger.getLogger(EditableTimeEffortModifyListener.class);

    private Activity activity;
    private Text text;
    private Display display;
    private TreeViewer treeViewer;
    private TreeItem item;
    private ICommandHandler commandHandler;
    
    private SurfaceFactory factory = new SurfaceFactory();
    
    private List<Object> itemList;

    public EditableTimeEffortModifyListener(Activity activity, Text text, Display display, TreeViewer treeViewer,
            TreeItem item, ICommandHandler commandHandler) {
        this.activity = activity;
        this.text = text;
        this.display = display;
        this.treeViewer = treeViewer;
        this.item = item;
        this.itemList = new ArrayList<Object>();
        this.commandHandler = commandHandler;
    }

    @Override
    public void modifyText(ModifyEvent e) {

        StringBuffer buffer = new StringBuffer(text.getText());

        int index = buffer.indexOf(",");

        if (index > (-1)) {
            buffer.setCharAt(index, '.');
        }

        Double value = 0.0;
        try {
            value = Double.parseDouble(buffer.toString());
            text.setForeground(factory.lookupColor(display, 0, 0, 0, "black"));
            text.setToolTipText(null);
        } catch (Exception exception) {
            text.setToolTipText("No correct time value");
            text.setForeground(factory.lookupColor(display, 255, 0, 0, "red"));
        }
        ;
        Command command = new EditTimeEffortCommand(this.activity, value);
        this.commandHandler.handleCommand(command);

        Object[] elementsToUpdate = getItemsToUpdate(item);
        if (elementsToUpdate != null)
            this.treeViewer.update(elementsToUpdate, new String[] { "Accumulated Effort" });
        this.itemList = new ArrayList<Object>();
    }

    private Object[] getItemsToUpdate(TreeItem item) {

        TreeItem parentItem = item.getParentItem();
        if (parentItem != null)
            getItemsToUpdate(parentItem);

        this.itemList.add(item.getData());

        return itemList.toArray();

    }
}
