package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Text;

import de.fzi.maintainabilitymodel.workplan.Activity;

public class EditableTimeEffortCellListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(EditableTimeEffortCellListener.class);

    private Activity activity;
    private Text text;

    public EditableTimeEffortCellListener(Activity activity, Text text) {
        this.activity = activity;
        this.text = text;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {

        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        Double value = Double.parseDouble(text.getText());

        activity.setWorkTimeEstimate(value);

        super.widgetSelected(e);
    }

}
