package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class DeveloperStructureButtonListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(DeveloperStructureButtonListener.class);

    private IMainEditor editor;
    private Button isDeveloperStructureButton;
    private Tree tree;

    public DeveloperStructureButtonListener(IMainEditor editor, Tree tree, Button isDeveloperStructureButton) {
        this.editor = editor;
        this.isDeveloperStructureButton = isDeveloperStructureButton;
        this.tree = tree;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (tree.getData() instanceof Workplan)
            editor.getCentralPage().showDeveloperStructure(isDeveloperStructureButton.getSelection());
        super.widgetSelected(e);
    }

}
