package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.WorkPlanManager;
import de.fzi.kamp.ui.general.DialogManager;

public class DeleteActivityFromWorkplanListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(DeleteActivityFromWorkplanListener.class);

    private IMainEditor mainEditor;
    private TreeItem item;

    public DeleteActivityFromWorkplanListener(IMainEditor commandHandler, TreeItem item) {
        super();
        this.mainEditor = commandHandler;
        this.item = item;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        WorkPlanManager manager = new WorkPlanManager(new DialogManager(this.mainEditor), null);
        manager.removeWorkActivity(this.mainEditor, item);
        super.widgetSelected(e);
    }

}
