package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.activator.Activator;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;

public class ContextMenuMouseListenerForWorkplanTree extends MouseAdapter {
    private final static Logger logger = Logger.getLogger(ContextMenuMouseListenerForWorkplanTree.class);

    private Tree tree;
    private IMainEditor mainEditor;
    private static final int RIGHT_MOUSE_BUTTON = 3;

    public ContextMenuMouseListenerForWorkplanTree(Tree tree, IMainEditor mainEditor) {

        this.tree = tree;
        this.mainEditor = mainEditor;
    }

    @Override
    public void mouseDown(MouseEvent e) {
    	
    	//condition deactivates context menu, if effort estimation view is open
    	if(!this.mainEditor.getCentralPage().effortEstimationViewIsActivated()){
	        if (e.button == RIGHT_MOUSE_BUTTON) {
	            if (e.widget instanceof Tree) {
	            	Activity task = (Activity) tree.getSelection()[0].getData();
	                
	                boolean isRootComposite = false;
	                if(task instanceof CompositeTask){
	                	//tests whether the selected item is the root composite task
	                	if(((CompositeTask)task).getTaskrationale().getKeyword().equals("Complete Workplan")){
	                		isRootComposite = true;
	                	}
	                }
	                if(!isRootComposite){
	                	
	                	Menu rightButton = new Menu(tree);	
		                MenuItem addItem = createMenuItem(rightButton, SWT.CASCADE, "Edit");
		                addItem.addSelectionListener(new AddCompositeActivityListener(tree, this.mainEditor));	                	
	                	
                		if (task instanceof ImplementOperationActivity || task instanceof ChangeOperationImplementationActivity
		                        || task instanceof RemoveOperationImplementationActivity) {
		                    addItem.setEnabled(false);
		                }
		                // just to test the logging to the eclipse error log
		                // TODO remove!
		                // Status errorStatus = new Status(Status.ERROR, getClass().getName(),
		                // "TESTTESTTEST");
		                // final Bundle bundle = Platform.getBundle(Activator.PLUGIN_ID);
		                // Platform.getLog(bundle).log(errorStatus);
		
		                createMenuItem(rightButton, SWT.SEPARATOR, "");
		
		                MenuItem deleteItem = createMenuItem(rightButton, SWT.CASCADE, "Delete Activity");
		                deleteItem.addSelectionListener(new DeleteActivityFromWorkplanListener(mainEditor,
		                        tree.getSelection()[0]));
		                if (tree.getSelection()[0].getItemCount() > 0)
		                    					deleteItem.setEnabled(false);
		
		                tree.setMenu(rightButton);
	                }else{
	                	if(this.tree.getMenu() != null){
	                		this.tree.getMenu().dispose();
	                	}
	                }	                
	            }	            
	        }
    	}   	
        super.mouseDown(e);
    }

    private MenuItem createMenuItem(Menu menu, int style, String text) {
        MenuItem item = new MenuItem(menu, style);
        item.setText(text);

        ImageDescriptor desc = Activator.getImageDescriptor("/icons/qimpress.gif");

        item.setImage(desc.createImage());

        return item;
    }
}
