package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.WorkPlanManager;
import de.fzi.kamp.ui.general.DialogManager;
import de.fzi.kamp.ui.general.WizardManager;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class AddTopLevelActivitiesListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(AddTopLevelActivitiesListener.class);

    private Tree tree;
    private IMainEditor editor;

    public AddTopLevelActivitiesListener(IMainEditor editor, Tree tree) {
        this.editor = editor;
        this.tree = tree;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        WizardManager wizardManager = new WizardManager();
        WorkPlanManager workplanManager = new WorkPlanManager(new DialogManager(this.editor), ((Workplan) tree
                .getData()).getEffortanalaysisinstance());
        workplanManager.addTopLevelActivity(editor, tree, wizardManager);

        super.widgetSelected(e);
    }

}
