package de.fzi.kamp.ui.workplanediting.listeners;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.WorkPlanManager;
import de.fzi.kamp.ui.general.DialogManager;
import de.fzi.kamp.ui.general.WizardManager;
import de.fzi.maintainabilitymodel.workplan.Workplan;

public class AddCompositeActivityListener extends SelectionAdapter {
    private final static Logger logger = Logger.getLogger(AddCompositeActivityListener.class);

    private Tree tree;
    private IMainEditor mainEditor;

    public AddCompositeActivityListener(Tree tree, IMainEditor mainEditor) {
        this.tree = tree;
        this.mainEditor = mainEditor;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {

        WorkPlanManager workplanManager = new WorkPlanManager(new DialogManager(this.mainEditor), ((Workplan) tree
                .getData()).getEffortanalaysisinstance());
        workplanManager.refineSelectedAvtivity(tree, mainEditor, new WizardManager());

        super.widgetSelected(e);
    }

}
